/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.wrappers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.IMethodCall;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.method.LuaTypeQualifier;
import openperipheral.api.adapter.CallbackProperty;
import openperipheral.api.adapter.IPropertyCallback;
import openperipheral.api.adapter.Property;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.converter.IConverter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PropertyListBuilder {
    private static final ImmutableMap<String, Class<?>> NEEDED_ENV = ImmutableMap.builder().put((Object)"converter", IConverter.class).build();
    private static final List<Object> EMPTY_ARGS = ImmutableList.of();
    private static final List<Object> NO_RETURNS = ImmutableList.of();

    private static IPropertyCallback createDefaultCallback(final Object owner) {
        return new IPropertyCallback(){

            @Override
            public void setField(Field field, Object value) {
                try {
                    field.set(owner, value);
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }

            @Override
            public Object getField(Field field) {
                try {
                    return field.get(owner);
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
    }

    private static ImmutablePair<GetterContext, SetterContext> createContexts(Field field, String source, String name, ArgType type, String getterDescription, String setterDescription, boolean isDelegating, boolean readOnly) {
        SetterContext setter;
        GetterContext getter;
        int modifiers = field.getModifiers();
        Preconditions.checkArgument(((readOnly || !Modifier.isFinal(modifiers)) && !Modifier.isStatic(modifiers) ? 1 : 0) != 0, (Object)"Field marked with @Property can't be either final or static");
        field.setAccessible(true);
        if (type == ArgType.AUTO) {
            Class<?> fieldType = field.getType();
            type = LuaTypeQualifier.qualifyArgType(fieldType);
        }
        if (Strings.isNullOrEmpty((String)name)) {
            name = field.getName();
        }
        String capitalizedName = StringUtils.capitalize((String)name);
        if (Strings.isNullOrEmpty((String)getterDescription)) {
            getterDescription = "Get field '" + name + "' value";
        }
        if (Strings.isNullOrEmpty((String)setterDescription)) {
            setterDescription = "Set field '" + name + "' value";
        }
        if (isDelegating) {
            getter = new DelegatingGetterContext(capitalizedName, getterDescription, type, field, source);
            setter = readOnly ? null : new DelegatingSetterContext(capitalizedName, setterDescription, type, field, source);
        } else {
            getter = new DefaultGetterContext(capitalizedName, getterDescription, type, field, source);
            setter = readOnly ? null : new DefaultSetterContext(capitalizedName, setterDescription, type, field, source);
        }
        return ImmutablePair.of((Object)getter, (Object)setter);
    }

    private static void addMethods(Pair<GetterContext, SetterContext> context, List<IMethodExecutor> output) {
        PropertyExecutor getter = new PropertyExecutor((FieldContext)context.getLeft());
        output.add(getter);
        if (context.getRight() != null) {
            PropertyExecutor setter = new PropertyExecutor((FieldContext)context.getRight());
            output.add(setter);
        }
    }

    public static void buildPropertyList(Class<?> targetCls, String source, List<IMethodExecutor> output) {
        for (Field f : targetCls.getDeclaredFields()) {
            Annotation p = f.getAnnotation(Property.class);
            if (p != null) {
                PropertyListBuilder.addMethods(PropertyListBuilder.createContexts(f, source, p.name(), p.type(), p.getterDesc(), p.setterDesc(), false, p.readOnly()), output);
                continue;
            }
            p = f.getAnnotation(CallbackProperty.class);
            if (p == null) continue;
            Preconditions.checkArgument((boolean)IPropertyCallback.class.isAssignableFrom(targetCls));
            PropertyListBuilder.addMethods(PropertyListBuilder.createContexts(f, source, p.name(), p.type(), p.getterDesc(), p.setterDesc(), true, p.readOnly()), output);
        }
    }

    public static interface IPropertyExecutorFactory {
        public IMethodExecutor createExecutor(FieldContext var1);
    }

    private static class DelegatingSetterContext
    extends SetterContext {
        protected DelegatingSetterContext(String capitalizedName, String description, ArgType type, Field field, String source) {
            super(capitalizedName, description, type, field, source);
        }

        @Override
        protected IPropertyCallback getCallback(Object target) {
            Preconditions.checkArgument((boolean)(target instanceof IPropertyCallback), (Object)"Invalid target. Probably not your fault");
            return (IPropertyCallback)target;
        }
    }

    private static class DelegatingGetterContext
    extends GetterContext {
        protected DelegatingGetterContext(String capitalizedName, String description, ArgType type, Field field, String source) {
            super(capitalizedName, description, type, field, source);
        }

        @Override
        protected IPropertyCallback getCallback(Object target) {
            Preconditions.checkArgument((boolean)(target instanceof IPropertyCallback), (Object)"Invalid target. Probably not your fault");
            return (IPropertyCallback)target;
        }
    }

    private static class DefaultSetterContext
    extends SetterContext {
        protected DefaultSetterContext(String capitalizedName, String description, ArgType type, Field field, String source) {
            super(capitalizedName, description, type, field, source);
        }

        @Override
        protected IPropertyCallback getCallback(Object target) {
            return PropertyListBuilder.createDefaultCallback(target);
        }
    }

    private static class DefaultGetterContext
    extends GetterContext {
        protected DefaultGetterContext(String capitalizedName, String description, ArgType type, Field field, String source) {
            super(capitalizedName, description, type, field, source);
        }

        @Override
        protected IPropertyCallback getCallback(Object target) {
            return PropertyListBuilder.createDefaultCallback(target);
        }
    }

    private static abstract class SetterContext
    extends FieldContext {
        protected SetterContext(String capitalizedName, String description, ArgType type, Field field, String source) {
            super("set" + capitalizedName, description, type, field, source);
        }

        @Override
        public Object[] call(IConverter converter, Object target, Object ... args) {
            Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Setter must have exactly one argument");
            Object arg = args[0];
            Object converted = converter.toJava(arg, this.field.getGenericType());
            this.getCallback(target).setField(this.field, converted);
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }

        @Override
        public String signature() {
            return "(value)";
        }

        @Override
        public String doc() {
            return String.format("function(%s) -- %s", this.type.name(), this.description);
        }

        @Override
        public String doc(String name) {
            return String.format("function %s(%s) -- %s", name, this.type.name(), this.description);
        }

        @Override
        public Map<String, Object> describe() {
            HashMap args = Maps.newHashMap();
            args.put("name", "value");
            args.put("type", this.type.toString());
            Map<String, Object> result = super.describe();
            result.put("args", args);
            result.put("returnTypes", NO_RETURNS);
            return result;
        }
    }

    private static abstract class GetterContext
    extends FieldContext {
        protected GetterContext(String capitalizedName, String description, ArgType type, Field field, String source) {
            super("get" + capitalizedName, description, type, field, source);
        }

        @Override
        public Object[] call(IConverter converter, Object target, Object ... args) {
            Preconditions.checkArgument((args.length == 0 ? 1 : 0) != 0, (Object)"Getter has no arguments");
            Object result = this.getCallback(target).getField(this.field);
            return ArrayUtils.toArray((Object[])new Object[]{converter.fromJava(result)});
        }

        @Override
        public String signature() {
            return "()";
        }

        @Override
        public String doc() {
            return String.format("function():%s -- %s", this.type.name(), this.description);
        }

        @Override
        public String doc(String name) {
            return String.format("function %s():%s -- %s", name, this.type.name(), this.description);
        }

        @Override
        public Map<String, Object> describe() {
            Map<String, Object> result = super.describe();
            result.put("args", EMPTY_ARGS);
            result.put("returnTypes", ImmutableList.of((Object)this.type.toString()));
            return result;
        }
    }

    public static abstract class FieldContext
    implements IDescriptable {
        private final String name;
        protected final String description;
        protected ArgType type;
        protected final Field field;
        private final String source;

        protected FieldContext(String name, String description, ArgType type, Field field, String source) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.field = field;
            this.source = source;
        }

        public abstract Object[] call(IConverter var1, Object var2, Object ... var3);

        protected abstract IPropertyCallback getCallback(Object var1);

        @Override
        public List<String> getNames() {
            return ImmutableList.of((Object)this.name);
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public Map<String, Object> describe() {
            HashMap result = Maps.newHashMap();
            result.put("description", this.description);
            result.put("source", this.source);
            return result;
        }
    }

    public static class PropertyExecutor
    implements IMethodExecutor {
        private final FieldContext context;

        public PropertyExecutor(FieldContext context) {
            this.context = context;
        }

        @Override
        public IDescriptable description() {
            return this.context;
        }

        @Override
        public IMethodCall startCall(final Object target) {
            return new IMethodCall(){
                private IConverter converter;

                @Override
                public IMethodCall setPositionalArg(int index, Object value) {
                    return this;
                }

                @Override
                public IMethodCall setOptionalArg(String name, Object value) {
                    if ("converter".equals(name)) {
                        this.converter = (IConverter)value;
                    }
                    return this;
                }

                @Override
                public Object[] call(Object[] args) {
                    return PropertyExecutor.this.context.call(this.converter, target, args);
                }
            };
        }

        @Override
        public boolean isAsynchronous() {
            return true;
        }

        @Override
        public boolean canInclude(String architecture) {
            return true;
        }

        @Override
        public Map<String, Class<?>> requiredEnv() {
            return NEEDED_ENV;
        }
    }
}

