/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import openmods.Log;
import openmods.utils.CollectionUtils;

public class RecipeUtils {
    private static final ItemStack[] EMPTY_ITEM_STACK_ARRAY = new ItemStack[0];
    private static Field shapedOreRecipeWidth;

    public static List<IRecipe> getVanillaRecipes() {
        return CraftingManager.func_77594_a().func_77592_b();
    }

    public static ItemStack[] getFirstRecipeForItem(ItemStack resultingItem) {
        for (IRecipe recipe : RecipeUtils.getVanillaRecipes()) {
            Object[] input;
            ItemStack result;
            if (recipe == null || (result = recipe.func_77571_b()) == null || !result.func_77969_a(resultingItem) || (input = RecipeUtils.getRecipeInput(recipe)) == null) continue;
            return RecipeUtils.convertToStacks(input);
        }
        return null;
    }

    public static ItemStack[] convertToStacks(Object[] input) {
        ItemStack[] result = new ItemStack[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = RecipeUtils.convertToStack(input[i]);
        }
        return result;
    }

    public static ItemStack convertToStack(Object obj) {
        ItemStack entry = null;
        if (obj instanceof ItemStack) {
            entry = (ItemStack)obj;
        } else if (obj instanceof List) {
            List list = (List)obj;
            entry = (ItemStack)CollectionUtils.getRandom(list);
        }
        if (entry == null) {
            return null;
        }
        if ((entry = entry.func_77946_l()).func_77960_j() == Short.MAX_VALUE) {
            entry.func_77964_b(0);
        }
        return entry;
    }

    public static Object[] getRecipeInput(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return ((ShapelessOreRecipe)recipe).getInput().toArray();
        }
        if (recipe instanceof ShapedOreRecipe) {
            return RecipeUtils.getShapedOreRecipe((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)recipe).field_77574_d;
        }
        if (recipe instanceof ShapelessRecipes) {
            return ((ShapelessRecipes)recipe).field_77579_b.toArray(EMPTY_ITEM_STACK_ARRAY);
        }
        return null;
    }

    private static Object[] getShapedOreRecipe(ShapedOreRecipe recipe) {
        int width;
        try {
            width = RecipeUtils.getRecipeWidth(recipe);
        }
        catch (Exception e) {
            Log.severe(e, "Failed to get input information from %s", recipe);
            return null;
        }
        Object[] input = recipe.getInput();
        int inputIndex = 0;
        Object[] grid = new Object[9];
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int outputIndex = y * 3 + x;
                if (x < width && inputIndex < input.length) {
                    grid[outputIndex] = input[inputIndex];
                    ++inputIndex;
                    continue;
                }
                grid[outputIndex] = null;
            }
        }
        return grid;
    }

    private static int getRecipeWidth(ShapedOreRecipe recipe) throws Exception {
        if (shapedOreRecipeWidth == null) {
            shapedOreRecipeWidth = ShapedOreRecipe.class.getDeclaredField("width");
            shapedOreRecipeWidth.setAccessible(true);
        }
        int width = shapedOreRecipeWidth.getInt(recipe);
        return width;
    }
}

