/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import openmods.reflection.InstanceFieldAccess;
import openmods.structured.IStructureElement;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.TypeRW;

public class ElementField
extends InstanceFieldAccess<Object>
implements IStructureElement {
    private int elementId;
    public final IStreamSerializer<Object> serializer;

    public ElementField(Object parent, Field field) {
        super(parent, field);
        Class<?> fieldType = field.getType();
        this.serializer = TypeRW.STREAM_SERIALIZERS.get(fieldType);
        Preconditions.checkNotNull(this.serializer, (Object)"Invalid field type");
    }

    @Override
    public void writeToStream(DataOutput output) throws IOException {
        Object value = this.get();
        this.serializer.writeToStream(value, output);
    }

    @Override
    public void readFromStream(DataInput input) throws IOException {
        Object value = this.serializer.readFromStream(input);
        this.set(value);
    }

    @Override
    public int getId() {
        return this.elementId;
    }

    @Override
    public void setId(int id) {
        this.elementId = id;
    }
}

