/*
 * Decompiled with CFR 0.152.
 */
package openmods.physics;

import com.google.common.collect.Lists;
import java.util.List;
import openmods.physics.Constraint;
import openmods.physics.FastVector;
import openmods.physics.Point;

public class Cloth {
    private List<Constraint> constraints = Lists.newArrayList();
    public Point[][] points;
    private double max_dim;
    private double spacing;
    private int num_x_points;
    private int num_y_points;
    private int n_constraints;
    private static final int PHYSICS_ITERATIONS = 2;

    public Cloth(int density, double width, double height) {
        this.max_dim = Math.max(width, height);
        Math.min(width, height);
        this.spacing = this.max_dim / (double)density;
        this.num_x_points = (int)((double)density * (width / this.max_dim) + 0.5);
        this.num_y_points = (int)((double)density * (height / this.max_dim) + 0.5);
        this.points = new Point[this.num_y_points][];
        int i = 0;
        double y = 0.0;
        while (i < this.num_y_points) {
            this.points[i] = new Point[this.num_x_points];
            int j = 0;
            double x = 0.0;
            while (j < this.num_x_points) {
                this.points[i][j] = new Point(x / width, y / height, 0.0);
                if (i > 0) {
                    this.constraints.add(new Constraint(this.points[i - 1][j], this.points[i][j], Double.NaN));
                }
                if (j > 0) {
                    this.constraints.add(new Constraint(this.points[i][j - 1], this.points[i][j], Double.NaN));
                }
                ++j;
                x += this.spacing;
            }
            ++i;
            y += this.spacing;
        }
        this.points[0][0].inv_mass = 0.0;
        this.points[0][this.num_x_points / 2].inv_mass = 0.0;
        this.points[0][this.num_x_points - 1].inv_mass = 0.0;
        this.n_constraints = this.constraints.size();
    }

    public void update() {
        int j;
        int i;
        int num_x = this.num_x_points;
        int num_y = this.num_y_points;
        int num_c = this.n_constraints;
        int num_i = 2;
        for (i = 0; i < num_y; ++i) {
            for (j = 0; j < num_x; ++j) {
                this.points[i][j].update();
            }
        }
        for (j = 0; j < num_i; ++j) {
            for (i = 0; i < num_c; ++i) {
                this.constraints.get(i).update();
            }
        }
    }

    public Point getClosestPoint(FastVector pos) {
        int num_x = this.num_x_points;
        int num_y = this.num_y_points;
        double min_dist = 1.0;
        Point min_point = null;
        for (int i = 0; i < num_y; ++i) {
            for (int j = 0; j < num_x; ++j) {
                double dist = pos.subtract(this.points[i][j].getCurrent()).length();
                if (!(dist < min_dist)) continue;
                min_dist = dist;
                min_point = this.points[i][j];
            }
        }
        return min_point;
    }
}

