/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import openmods.OpenMods;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.MethodIdRegistry;
import openmods.network.rpc.MethodParamsCodec;
import openmods.network.rpc.RpcCall;
import openmods.network.rpc.TargetWrapperRegistry;
import openmods.utils.ByteUtils;

@ChannelHandler.Sharable
public class RpcCallCodec
extends MessageToMessageCodec<FMLProxyPacket, RpcCall> {
    private final TargetWrapperRegistry targetRegistry;
    private final MethodIdRegistry methodRegistry;

    public RpcCallCodec(TargetWrapperRegistry targetRegistry, MethodIdRegistry methodRegistry) {
        this.targetRegistry = targetRegistry;
        this.methodRegistry = methodRegistry;
    }

    protected void encode(ChannelHandlerContext ctx, RpcCall call, List<Object> out) throws Exception {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream output = new ByteBufOutputStream(buf);
        IRpcTarget targetWrapper = call.target;
        int targetId = this.targetRegistry.getWrapperId(targetWrapper.getClass());
        ByteUtils.writeVLI((DataOutput)output, targetId);
        targetWrapper.writeToStream((DataOutput)output);
        Method method = call.method;
        int methodId = this.methodRegistry.methodToId(method);
        ByteUtils.writeVLI((DataOutput)output, methodId);
        MethodParamsCodec paramsCodec = MethodParamsCodec.create(method);
        paramsCodec.writeArgs((DataOutput)output, call.args);
        FMLProxyPacket packet = new FMLProxyPacket(buf.copy(), "OpenMods|RPC");
        out.add(packet);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBufInputStream input = new ByteBufInputStream(msg.payload());
        int targetId = ByteUtils.readVLI((DataInput)input);
        IRpcTarget target = this.targetRegistry.createWrapperFromId(targetId);
        EntityPlayer player = this.getPlayer(msg);
        target.readFromStreamStream(player, (DataInput)input);
        int methodId = ByteUtils.readVLI((DataInput)input);
        Method method = this.methodRegistry.idToMethod(methodId);
        MethodParamsCodec paramsCodec = MethodParamsCodec.create(method);
        Object[] args = paramsCodec.readArgs((DataInput)input);
        int bufferJunkSize = input.available();
        Preconditions.checkState((bufferJunkSize == 0 ? 1 : 0) != 0, (String)"%s junk bytes left in buffer, method = %s", (Object[])new Object[]{bufferJunkSize, method});
        out.add(new RpcCall(target, method, args));
    }

    protected EntityPlayer getPlayer(FMLProxyPacket msg) {
        INetHandler handler = msg.handler();
        EntityPlayer player = OpenMods.proxy.getPlayerFromHandler(handler);
        Preconditions.checkNotNull((Object)player, (String)"Can't get player from handler %s", (Object[])new Object[]{handler});
        return player;
    }
}

