/*
 * Decompiled with CFR 0.152.
 */
package org.github.trainerguy22.jtoml.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.github.trainerguy22.jtoml.TomlParser;
import org.github.trainerguy22.jtoml.Util;
import org.github.trainerguy22.jtoml.impl.SimpleTomlParser;
import org.github.trainerguy22.jtoml.impl.SimpleTomlWriter;

public class Toml {
    private static final Logger LOGGER = Logger.getLogger(Toml.class.getName());
    private static TomlParser parser;

    public static Map<String, Object> parse(String tomlString) {
        return Toml.parse(tomlString, null);
    }

    public static Map<String, Object> parse(String tomlString, TomlParser tomlParser) {
        return Toml.parseString(tomlString);
    }

    public static Map<String, Object> parse(File file) throws IOException {
        return Toml.parse(file, null);
    }

    public static Map<String, Object> parse(File file, TomlParser tomlParser) throws IOException {
        return Toml.parseFile(file);
    }

    public static Map<String, Object> parseString(String string) {
        return parser.parse(string);
    }

    public static Map<String, Object> parseFile(File file) throws FileNotFoundException {
        return Toml.parseString(Util.FileToString.read(file));
    }

    private static void initDefaultParser() {
        parser = new SimpleTomlParser();
    }

    public static void write(File file, Map<String, Object> config) {
        try {
            new SimpleTomlWriter(file).write(config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Toml.initDefaultParser();
    }
}

