/*
 * Decompiled with CFR 0.152.
 */
package lib.enderwizards.sandstone.mod.config;

import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lib.enderwizards.sandstone.mod.config.Config;
import lib.enderwizards.sandstone.mod.config.ConfigElement;
import lib.enderwizards.sandstone.mod.config.ConfigReference;
import org.github.trainerguy22.jtoml.impl.Toml;

public class ConfigImpl
extends Config {
    private Map<String, Object> config;
    private Map<String, Object> defaults = new HashMap<String, Object>();
    private File file;

    public ConfigImpl(File file, Map<String, Object> config) {
        this.file = file;
        this.config = config;
    }

    @Override
    public Map<String, Object> getGroup(String group) {
        return this.config.get(group) instanceof Map ? (Map)this.config.get(group) : null;
    }

    public Map<String, Object> getDefaultGroup(String group) {
        return this.defaults.get(group) instanceof Map ? (Map)this.defaults.get(group) : null;
    }

    @Override
    public void require(String group, String key, ConfigReference def) {
        if (def.side == Side.CLIENT && FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return;
        }
        if (this.getDefaultGroup(group) == null) {
            if (this.defaults.get(group) != null) {
                this.defaults.remove(group);
            }
            this.defaults.put(group, new HashMap());
        }
        this.getDefaultGroup(group).put(key, def);
        if (this.getGroup(group) == null) {
            if (this.config.get(group) != null) {
                this.config.remove(group);
            }
            this.config.put(group, new HashMap());
        }
        if (this.getGroup(group).containsKey(key)) {
            return;
        }
        this.getGroup(group).put(key, def.defaultValue);
    }

    @Override
    public Object get(String group, String key) {
        Object object = this.getGroup(group) == null ? this.config.get(key) : this.getGroup(group).get(key);
        return object;
    }

    @Override
    public Integer getInt(String group, String key) {
        if (this.get(group, key) instanceof Integer) {
            return (Integer)this.get(group, key);
        }
        return null;
    }

    @Override
    public boolean getBool(String group, String key) {
        return (Boolean)this.get(group, key);
    }

    @Override
    public List<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        for (String key : this.config.keySet()) {
            if (this.getGroup(key) == null) continue;
            groups.add(key);
        }
        return groups;
    }

    @Override
    public List<Object> getKeys(String prefix) {
        ArrayList<Object> keys = new ArrayList<Object>();
        if (this.getGroup(prefix) == null) {
            return keys;
        }
        keys.addAll(this.getGroup(prefix).values());
        return keys;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void save() {
        Toml.write(this.file, this.config);
    }

    @Override
    public List<IConfigElement> toGui(String mod_id) {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        for (String key : this.config.keySet()) {
            if (!this.defaults.containsKey(key)) continue;
            try {
                elements.add(ConfigElement.getTypedElement(mod_id, key, this.config, this.defaults));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return elements;
    }

    @Override
    public void set(String group, String key, Object value) {
        if (this.getGroup(group) == null) {
            this.config.put(key, value);
        } else {
            this.getGroup(group).put(key, value);
        }
    }
}

