/*
 * Decompiled with CFR 0.152.
 */
package lib.enderwizards.sandstone.mod.config;

import cpw.mods.fml.client.config.ConfigGuiType;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.GuiEditArrayEntries;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lib.enderwizards.sandstone.mod.config.Config;
import lib.enderwizards.sandstone.mod.config.ConfigImpl;
import lib.enderwizards.sandstone.mod.config.ConfigReference;

public class ConfigElement<T>
implements IConfigElement<T> {
    private boolean isProperty;
    public String mod_id;
    private String group;
    private String key;
    private Config config;
    private Config def;

    public ConfigElement(String mod_id, String key, Map<String, Object> config, Map<String, Object> def) {
        this(mod_id, "", key, config, def);
    }

    public ConfigElement(String mod_id, String group, String key, Map<String, Object> config, Map<String, Object> def) {
        this.mod_id = mod_id;
        this.group = group;
        this.key = key;
        this.config = new ConfigImpl(null, config);
        this.def = new ConfigImpl(null, def);
        if (this.config.get(group, key) instanceof Map) {
            this.isProperty = false;
            assert (this.def.get(group, key) instanceof Map);
        } else {
            this.isProperty = true;
        }
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return null;
    }

    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return null;
    }

    public String getName() {
        return this.key;
    }

    public String getQualifiedName() {
        return this.key;
    }

    public String getLanguageKey() {
        return this.mod_id + ".configgui." + this.getName();
    }

    public String getComment() {
        return "";
    }

    public List<IConfigElement> getChildElements() {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        Map<String, Object> map = this.config.getGroup(this.key);
        for (String key1 : map.keySet()) {
            elements.add(ConfigElement.getTypedElement(this.mod_id, this.key, key1, map, (Map)this.def.get("", this.key)));
        }
        return elements;
    }

    public ConfigGuiType getType() {
        ConfigGuiType type;
        if (this.def.get(this.group, this.key) instanceof ConfigReference && (type = ((ConfigReference)this.def.get((String)this.group, (String)this.key)).type) != null) {
            return type;
        }
        return ConfigElement.getType(this.config.get(this.group, this.key));
    }

    public static ConfigElement<?> getTypedElement(String mod_id, String key, Map<String, Object> value, Map<String, Object> def) {
        return ConfigElement.getTypedElement(mod_id, "", key, value, def);
    }

    public static ConfigElement<?> getTypedElement(String mod_id, String group, String key, Map<String, Object> value, Map<String, Object> def) {
        ConfigGuiType type = ConfigElement.getType(value);
        if (type == null) {
            return new ConfigElement(mod_id, key, value, def);
        }
        switch (type) {
            case BOOLEAN: {
                return new ConfigElement(mod_id, key, value, def);
            }
            case DOUBLE: {
                return new ConfigElement(mod_id, key, value, def);
            }
            case INTEGER: {
                return new ConfigElement(mod_id, key, value, def);
            }
        }
        return new ConfigElement(mod_id, key, value, def);
    }

    public static ConfigGuiType getType(Object object) {
        if (object instanceof Boolean) {
            return ConfigGuiType.BOOLEAN;
        }
        if (object instanceof Integer) {
            return ConfigGuiType.INTEGER;
        }
        if (object instanceof String) {
            return ConfigGuiType.STRING;
        }
        if (object instanceof Map) {
            return ConfigGuiType.CONFIG_CATEGORY;
        }
        return null;
    }

    public boolean isList() {
        return this.get() instanceof List;
    }

    public boolean isListLengthFixed() {
        return false;
    }

    public int getMaxListLength() {
        return -1;
    }

    public boolean isDefault() {
        if (this.get() instanceof List) {
            return Arrays.deepEquals(((List)this.get()).toArray(), this.getDefaults());
        }
        return this.config.get(this.group, this.key) == this.def.get(this.group, this.key);
    }

    public Object getDefault() {
        return ((ConfigReference)this.def.get((String)this.group, (String)this.key)).defaultValue;
    }

    public Object[] getDefaults() {
        if (this.get() instanceof List) {
            return ((List)this.get()).toArray();
        }
        return new Object[]{this.getDefault()};
    }

    public void setToDefault() {
        this.config.set(this.group, this.key, ((ConfigReference)this.def.get((String)this.group, (String)this.key)).defaultValue);
    }

    public boolean requiresWorldRestart() {
        return false;
    }

    public boolean showInGui() {
        return true;
    }

    public boolean requiresMcRestart() {
        return false;
    }

    public Object get() {
        return this.config.get(this.group, this.key);
    }

    public Object[] getList() {
        return ((List)this.config.get(this.group, this.key)).toArray();
    }

    public void set(T value) {
        this.config.set(this.group, this.key, value);
    }

    public void set(T[] aVal) {
        if (this.isProperty) {
            this.config.set(this.group, this.key, aVal);
        }
    }

    public String[] getValidValues() {
        return null;
    }

    public T getMinValue() {
        return (T)String.valueOf(((ConfigReference)this.def.get((String)this.group, (String)this.key)).minimum);
    }

    public T getMaxValue() {
        return (T)String.valueOf(((ConfigReference)this.def.get((String)this.group, (String)this.key)).maximum);
    }

    public Pattern getValidationPattern() {
        return null;
    }
}

