/*
 * Decompiled with CFR 0.152.
 */
package lib.enderwizards.sandstone.init;

import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import lib.enderwizards.sandstone.Sandstone;
import lib.enderwizards.sandstone.blocks.ICustomItemBlock;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.mod.ModRegistry;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class Content {
    public static Content DEFAULT = new Content("libsandstone");
    public List<String> registeredObjectNames = new ArrayList<String>();
    private String modId;

    public Content(String modId) {
        this.modId = modId;
    }

    public void init(ClassLoader classLoader, String packageName) throws Exception {
        ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
        for (ClassPath.ClassInfo info : classPath.getTopLevelClasses(packageName)) {
            Class<?> objClass = Class.forName(info.getName());
            this.checkAndRegister(objClass);
            for (Class<?> subClass : objClass.getClasses()) {
                this.checkAndRegister(subClass);
            }
        }
    }

    private void checkAndRegister(Class objClass) throws Exception {
        if (objClass.isAnnotationPresent(ContentInit.class)) {
            Object obj = objClass.newInstance();
            if (obj instanceof Item) {
                Item item = (Item)obj;
                GameRegistry.registerItem((Item)item, (String)item.func_77658_a().substring(5));
                if (!this.registeredObjectNames.contains(ContentHelper.getIdent(item))) {
                    this.registeredObjectNames.add(ContentHelper.getIdent(item));
                }
            } else if (obj instanceof Block) {
                Block block = (Block)obj;
                if (obj instanceof ICustomItemBlock) {
                    GameRegistry.registerBlock((Block)block, ((ICustomItemBlock)obj).getCustomItemBlock(), (String)block.func_149739_a().substring(5));
                    if (!this.registeredObjectNames.contains(ContentHelper.getIdent(block))) {
                        this.registeredObjectNames.add(ContentHelper.getIdent(block));
                    }
                } else {
                    GameRegistry.registerBlock((Block)block, (String)block.func_149739_a().substring(5));
                    if (!this.registeredObjectNames.contains(ContentHelper.getIdent(block))) {
                        this.registeredObjectNames.add(ContentHelper.getIdent(block));
                    }
                }
            } else {
                Sandstone.LOGGER.warn("Class '" + objClass.getName() + "' is not a Block or an Item! You shouldn't be calling @ContentInit on this! Ignoring!");
            }
        }
    }

    public Block getBlock(String blockName) {
        String selection = blockName;
        if (!selection.contains(":")) {
            selection = ModRegistry.getID(this.modId) + ":" + selection;
        }
        if (selection.indexOf(":") == 0) {
            selection = selection.substring(1);
        }
        return (Block)Block.field_149771_c.func_82594_a(selection);
    }

    public Item getItem(String itemName) {
        String selection = itemName;
        if (!selection.contains(":")) {
            selection = ModRegistry.getID(this.modId) + ":" + selection;
        }
        if (selection.indexOf(":") == 0) {
            selection = selection.substring(1);
        }
        return (Item)Item.field_150901_e.func_82594_a(selection);
    }

    public Item getItemBlock(String blockName) {
        String selection = blockName;
        if (!selection.contains(":")) {
            selection = ModRegistry.getID(this.modId) + ":" + selection;
        }
        if (selection.indexOf(":") == 0) {
            selection = selection.substring(1);
        }
        return Item.func_150898_a((Block)((Block)Block.field_149771_c.func_82594_a(selection)));
    }
}

