/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.plugins.thaumcraft;

import com.robrit.moofluids.common.util.EntityHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class AspectRegistry {
    public static void registerEntityAspects() {
        for (Fluid fluid : EntityHelper.getContainableFluidsArray()) {
            boolean hasAspects = false;
            ItemStack fluidBlockItemStack = new ItemStack(Blocks.field_150350_a);
            if (fluid.getBlock() != null) {
                fluidBlockItemStack = new ItemStack(fluid.getBlock());
                hasAspects = ThaumcraftApi.exists((Item)fluidBlockItemStack.func_77973_b(), (int)fluidBlockItemStack.func_77960_j());
            }
            AspectList entityAspects = new AspectList();
            if (fluid.canBePlacedInWorld() && hasAspects) {
                entityAspects = ThaumcraftApiHelper.getObjectAspects((ItemStack)fluidBlockItemStack);
            } else {
                entityAspects = new AspectList().add(Aspect.EARTH, 3).add(Aspect.BEAST, 3);
                if (fluid.isGaseous()) {
                    entityAspects.add(Aspect.AIR, 3);
                }
                if (fluid.getLuminosity() > 0) {
                    entityAspects.add(Aspect.LIGHT, 3);
                }
                if (fluid.getTemperature() >= FluidRegistry.LAVA.getTemperature()) {
                    entityAspects.add(Aspect.FIRE, 3);
                }
                if (fluid.getDensity() >= FluidRegistry.WATER.getDensity() * 3) {
                    entityAspects.add(Aspect.TRAP, 3);
                }
            }
            ThaumcraftApi.EntityTagsNBT entityIdentifierTag = new ThaumcraftApi.EntityTagsNBT("FluidName", (Object)fluid.getName());
            ThaumcraftApi.registerEntityTag((String)"EntityFluidCow", (AspectList)entityAspects, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[]{entityIdentifierTag});
        }
    }
}

