/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.event;

import com.robrit.moofluids.common.entity.EntityTypeData;
import com.robrit.moofluids.common.util.ColorHelper;
import com.robrit.moofluids.common.util.EntityHelper;
import com.robrit.moofluids.common.util.LogHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;

public class TextureRegisterEvent {
    private static final byte TEXTURE_MAP_ID_BLOCK = 0;
    private static final String SEPARATOR = "/";
    private static final String TEXTURE_LOCATION = "textures/entity/cow";
    private static final String BASE_TEXTURE = "textures/entity/cow/cow.png";

    public static void modifyTexture(Color colourOverlay, String fluidName) {
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(BASE_TEXTURE)).func_110527_b());
            File outputPath = new File(Minecraft.func_71410_x().field_71412_D + SEPARATOR + "assets" + SEPARATOR, "MooFluids".toLowerCase() + SEPARATOR + TEXTURE_LOCATION + SEPARATOR + fluidName + ".png");
            if (!outputPath.exists()) {
                int width = image.getWidth();
                int height = image.getHeight();
                Graphics g = image.getGraphics();
                g.setColor(colourOverlay);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int pixel = image.getRGB(x, y);
                        if (pixel >> 24 == 0) continue;
                        g.fillRect(x, y, 1, 1);
                    }
                }
                if (!outputPath.getParentFile().exists() && !outputPath.getParentFile().mkdirs()) {
                    return;
                }
                ImageIO.write((RenderedImage)image, "png", outputPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerTexture(String fluidName) {
        ResourceLocation entityTexture = new ResourceLocation("MooFluids".toLowerCase(), "textures/entity/cow/" + fluidName + ".png");
        EntityTypeData entityTypeData = EntityHelper.getEntityData(fluidName);
        entityTypeData.setTexture(entityTexture);
        EntityHelper.setEntityData(fluidName, entityTypeData);
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            for (Fluid fluid : EntityHelper.getContainableFluids().values()) {
                String fluidName = fluid.getName();
                int[][] textureData2d = event.map.func_110572_b(fluid.getIcon().func_94215_i()).func_147965_a(1);
                Color meanColour = ColorHelper.getMeanColour(textureData2d);
                EntityTypeData entityTypeData = EntityHelper.getEntityData(fluidName);
                entityTypeData.setOverlay(new Color(meanColour.getRed(), meanColour.getGreen(), meanColour.getBlue(), 128).getRGB());
                EntityHelper.setEntityData(fluidName, entityTypeData);
                LogHelper.info("Successfully added colour overlay for " + fluid.getLocalizedName());
                LogHelper.info(String.format("%s average colour R:%d, G:%d, B:%d", fluid.getLocalizedName(), meanColour.getRed(), meanColour.getGreen(), meanColour.getBlue()));
            }
        }
    }
}

