/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.event;

import com.robrit.moofluids.common.entity.EntityFluidCow;
import com.robrit.moofluids.common.util.EntityHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fluids.Fluid;

public class EntitySpawnHandler {
    private static final int SPAWN_LOWER_BOUNDARY = 3;
    private static final int SPAWN_UPPER_BOUNDARY = 5;
    private static final Fluid[] containableFluids = EntityHelper.getContainableFluidsArray();
    private static final Random random = new Random();

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        EntityFluidCow entityFluidCow;
        if (event.entity instanceof EntityFluidCow && (entityFluidCow = (EntityFluidCow)event.entity).getEntityFluid() == null) {
            Fluid entityFluid = this.getEntityFluid();
            entityFluidCow.setEntityFluid(entityFluid);
        }
    }

    private Fluid getEntityFluid() {
        if (containableFluids.length > 0) {
            Fluid currentEntityFluid = containableFluids[0];
            if (containableFluids.length > 1) {
                int fluidsToCheck = random.nextInt(2) + 3;
                Fluid[] possibleEntityFluids = new Fluid[fluidsToCheck];
                for (int currentFluidIndex = 0; currentFluidIndex < fluidsToCheck; ++currentFluidIndex) {
                    possibleEntityFluids[currentFluidIndex] = containableFluids[random.nextInt(containableFluids.length)];
                }
                int highestSpawnChance = 0;
                for (Fluid possibleEntityFluid : possibleEntityFluids) {
                    int currentSpawnChance;
                    int spawnRate = EntityHelper.getEntityData(possibleEntityFluid.getName()).getSpawnRate();
                    boolean isSpawnable = EntityHelper.getEntityData(possibleEntityFluid.getName()).isSpawnable();
                    if (!isSpawnable || spawnRate <= 0 || (currentSpawnChance = random.nextInt(spawnRate)) < highestSpawnChance) continue;
                    currentEntityFluid = possibleEntityFluid;
                    highestSpawnChance = currentSpawnChance;
                }
            }
            return currentEntityFluid;
        }
        return null;
    }
}

