/*
 * Decompiled with CFR 0.152.
 */
package com.foodplus.blocks.juicer;

import com.foodplus.core.FoodPlusItems;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class JuicerRecipeManager {
    private static final JuicerRecipeManager SMELTING_BASE = new JuicerRecipeManager();
    private Map smeltingList = new HashMap();
    private Map experienceList = new HashMap();

    public static JuicerRecipeManager smelting() {
        return SMELTING_BASE;
    }

    private JuicerRecipeManager() {
        this.addRecipie(Items.field_151034_e, new ItemStack(FoodPlusItems.AppleJuice, 1), 0.7f);
        this.addRecipie(FoodPlusItems.Orange, new ItemStack(FoodPlusItems.OrangeJuice, 1), 0.7f);
        this.addRecipie(FoodPlusItems.Pear, new ItemStack(FoodPlusItems.PearJuice, 1), 0.7f);
        this.addRecipie(FoodPlusItems.Cherry, new ItemStack(FoodPlusItems.CherryJuice, 1), 0.7f);
        this.addRecipie(FoodPlusItems.Kiwi, new ItemStack(FoodPlusItems.KiwiJuice, 1), 0.7f);
    }

    public void addRecipie(Item item, ItemStack itemstack, float experience) {
        this.addLists(item, itemstack, experience);
    }

    public void addLists(Item item, ItemStack itemstack, float experience) {
        this.putLists(new ItemStack(item, 1, Short.MAX_VALUE), itemstack, experience);
    }

    public Map getSmeltingList() {
        return this.smeltingList;
    }

    public void putLists(ItemStack itemstack, ItemStack itemstack2, float experience) {
        this.smeltingList.put(itemstack, itemstack2);
        this.experienceList.put(itemstack2, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack itemstack) {
        Map.Entry entry;
        Iterator iterator = this.smeltingList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.canBeSmelted(itemstack, (ItemStack)(entry = iterator.next()).getKey()));
        return (ItemStack)entry.getValue();
    }

    private boolean canBeSmelted(ItemStack itemstack, ItemStack itemstack2) {
        return itemstack2.func_77973_b() == itemstack.func_77973_b() && (itemstack2.func_77960_j() == Short.MAX_VALUE || itemstack2.func_77960_j() == itemstack.func_77960_j());
    }

    public float giveExperience(ItemStack itemstack) {
        Map.Entry entry;
        Iterator iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.canBeSmelted(itemstack, (ItemStack)(entry = iterator.next()).getKey()));
        if (itemstack.func_77973_b().getSmeltingExperience(itemstack) != -1.0f) {
            return itemstack.func_77973_b().getSmeltingExperience(itemstack);
        }
        return ((Float)entry.getValue()).floatValue();
    }
}

