/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.utils;

import java.util.List;
import minetweaker.IUndoableAction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseListRemoval
implements IUndoableAction {
    protected final String description;
    protected final List list;
    protected final FluidStack fluid;
    protected final ItemStack stack;
    protected Object recipe;

    public BaseListRemoval(String description, List list, ItemStack stack, FluidStack fluid) {
        this.list = list;
        this.stack = stack;
        this.description = description;
        this.fluid = fluid;
    }

    public BaseListRemoval(String description, List list, ItemStack stack) {
        this(description, list, stack, null);
    }

    public BaseListRemoval(String description, List list, FluidStack fluid) {
        this(description, list, null, fluid);
    }

    public BaseListRemoval(List list, ItemStack stack) {
        this(null, list, stack);
    }

    public BaseListRemoval(List list, FluidStack stack) {
        this(null, list, stack);
    }

    public BaseListRemoval(String description, List list) {
        this(description, list, null, null);
    }

    public boolean canUndo() {
        return this.list != null;
    }

    public void undo() {
        this.list.add(this.recipe);
    }

    public String getRecipeInfo() {
        return "Unknown Item";
    }

    public String describe() {
        if (this.recipe instanceof ItemStack) {
            return "Removing " + this.description + " Recipe for :" + ((ItemStack)this.recipe).func_82833_r();
        }
        if (this.recipe instanceof FluidStack) {
            return "Removing " + this.description + " Recipe for :" + ((FluidStack)this.recipe).getFluid().getLocalizedName();
        }
        return "Removing " + this.description + " Recipe for :" + this.getRecipeInfo();
    }

    public String describeUndo() {
        if (this.recipe instanceof ItemStack) {
            return "Restoring " + this.description + " Recipe for :" + ((ItemStack)this.recipe).func_82833_r();
        }
        if (this.recipe instanceof FluidStack) {
            return "Restoring " + this.description + " Recipe for :" + ((FluidStack)this.recipe).getFluid().getLocalizedName();
        }
        return "Restoring " + this.description + " Recipe for :" + this.getRecipeInfo();
    }

    public Object getOverrideKey() {
        return null;
    }
}

