/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.PulverizerManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Pulverizer")
public class Pulverizer {
    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add(energy, InputHelper.toStack(input), InputHelper.toStack(output), null, 0));
    }

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output, IItemStack secondary, int secondaryChance) {
        MineTweakerAPI.apply((IUndoableAction)new Add(energy, InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toStack(secondary), secondaryChance));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(input)));
    }

    private static class Remove
    implements IUndoableAction {
        ItemStack input;
        PulverizerManager.RecipePulverizer removed;

        public Remove(ItemStack inp) {
            this.input = inp;
        }

        public void apply() {
            this.removed = PulverizerManager.getRecipe((ItemStack)this.input);
            PulverizerManager.removeRecipe((ItemStack)this.input);
        }

        public boolean canUndo() {
            return this.removed != null;
        }

        public String describe() {
            return "Removing Pulverizer Recipe using " + this.input.func_82833_r();
        }

        public void undo() {
            PulverizerManager.addRecipe((int)this.removed.getEnergy(), (ItemStack)this.removed.getInput(), (ItemStack)this.removed.getPrimaryOutput(), (ItemStack)this.removed.getSecondaryOutput(), (int)this.removed.getSecondaryOutputChance());
        }

        public String describeUndo() {
            return "Restoring Pulverizer Recipe using " + this.input.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        ItemStack input;
        ItemStack output;
        ItemStack secondary;
        int secondaryChance;
        int energy;
        boolean applied = false;

        public Add(int rf, ItemStack inp, ItemStack out, ItemStack sec, int chance) {
            this.energy = rf;
            this.input = inp;
            this.output = out;
            this.secondary = sec;
            this.secondaryChance = chance;
        }

        public void apply() {
            this.applied = PulverizerManager.addRecipe((int)this.energy, (ItemStack)this.input, (ItemStack)this.output, (ItemStack)this.secondary, (int)this.secondaryChance);
        }

        public boolean canUndo() {
            return this.input != null && this.applied;
        }

        public String describe() {
            return "Adding Pulverizer Recipe using " + this.input.func_82833_r();
        }

        public void undo() {
            PulverizerManager.removeRecipe((ItemStack)this.input);
        }

        public String describeUndo() {
            return "Removing Pulverizer Recipe using " + this.input.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

