/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.player.IPlayer;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import modtweaker2.mods.thaumcraft.research.AddPage;
import modtweaker2.mods.thaumcraft.research.AddPrereq;
import modtweaker2.mods.thaumcraft.research.AddResearch;
import modtweaker2.mods.thaumcraft.research.AddSibling;
import modtweaker2.mods.thaumcraft.research.AddTab;
import modtweaker2.mods.thaumcraft.research.ClearPages;
import modtweaker2.mods.thaumcraft.research.ClearPrereqs;
import modtweaker2.mods.thaumcraft.research.ClearSiblings;
import modtweaker2.mods.thaumcraft.research.Difficulty;
import modtweaker2.mods.thaumcraft.research.MoveResearch;
import modtweaker2.mods.thaumcraft.research.OrphanResearch;
import modtweaker2.mods.thaumcraft.research.RefreshResearch;
import modtweaker2.mods.thaumcraft.research.RemoveResearch;
import modtweaker2.mods.thaumcraft.research.RemoveTab;
import modtweaker2.mods.thaumcraft.research.SetAspects;
import modtweaker2.mods.thaumcraft.research.SetResearch;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

@ZenClass(value="mods.thaumcraft.Research")
public class Research {
    private static final ResourceLocation defaultBackground = new ResourceLocation("thaumcraft", "textures/gui/gui_researchback.png");

    @ZenMethod
    public static void addTab(String key, String iconDomain, String iconPath) {
        Research.addTab(key, iconDomain, iconPath, null, null);
    }

    @ZenMethod
    public static void addTab(String key, String iconDomain, String iconPath, String backDomain, String backPath) {
        ResourceLocation icon = new ResourceLocation(iconDomain, iconPath);
        ResourceLocation background = backPath == null ? defaultBackground : new ResourceLocation(backDomain, backPath);
        Research.addTab(key, icon, background);
    }

    private static void addTab(String key, ResourceLocation icon, ResourceLocation background) {
        MineTweakerAPI.apply((IUndoableAction)new AddTab(key, icon, background));
    }

    @ZenMethod
    public static void removeTab(String tab) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveTab(tab));
    }

    @ZenMethod
    public static void removeResearch(String research) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveResearch(research));
    }

    @ZenMethod
    public static void orphanResearch(String research) {
        MineTweakerAPI.apply((IUndoableAction)new OrphanResearch(research));
    }

    @ZenMethod
    public static void addResearch(String key, String tab, @Optional String aspects, int x, int y, int difficulty, String domain, String path) {
        MineTweakerAPI.apply((IUndoableAction)new AddResearch(new ResearchItem(key, tab, ThaumcraftHelper.parseAspects(aspects), x, y, difficulty, new ResourceLocation(domain, path))));
    }

    @ZenMethod
    public static void addResearch(String key, String tab, @Optional String aspects, int x, int y, int difficulty, IItemStack item) {
        MineTweakerAPI.apply((IUndoableAction)new AddResearch(new ResearchItem(key, tab, ThaumcraftHelper.parseAspects(aspects), x, y, difficulty, InputHelper.toStack(item))));
    }

    @ZenMethod
    public static void addPage(String key, String unlocalized) {
        MineTweakerAPI.apply((IUndoableAction)new AddPage(key, ResearchPage.PageType.TEXT, unlocalized));
    }

    @ZenMethod
    public static void addCraftingPage(String key, IItemStack item) {
        MineTweakerAPI.apply((IUndoableAction)new AddPage(key, ResearchPage.PageType.NORMAL_CRAFTING, InputHelper.toStack(item)));
    }

    @ZenMethod
    public static void addCruciblePage(String key, IItemStack item) {
        MineTweakerAPI.apply((IUndoableAction)new AddPage(key, ResearchPage.PageType.CRUCIBLE_CRAFTING, InputHelper.toStack(item)));
    }

    @ZenMethod
    public static void addArcanePage(String key, IItemStack item) {
        MineTweakerAPI.apply((IUndoableAction)new AddPage(key, ResearchPage.PageType.ARCANE_CRAFTING, InputHelper.toStack(item)));
    }

    @ZenMethod
    public static void addInfusionPage(String key, IItemStack item) {
        MineTweakerAPI.apply((IUndoableAction)new AddPage(key, ResearchPage.PageType.INFUSION_CRAFTING, InputHelper.toStack(item)));
    }

    @ZenMethod
    public static void addEnchantmentPage(String key, int i) {
        MineTweakerAPI.apply((IUndoableAction)new AddPage(key, ResearchPage.PageType.INFUSION_ENCHANTMENT, Enchantment.field_77331_b[i]));
    }

    @ZenMethod
    public static void clearPages(String key) {
        MineTweakerAPI.apply((IUndoableAction)new ClearPages(key));
    }

    @ZenMethod
    public static void addPrereq(String key, String req, @Optional boolean hidden) {
        MineTweakerAPI.apply((IUndoableAction)new AddPrereq(key, req, hidden));
    }

    @ZenMethod
    public static void clearPrereqs(String key) {
        MineTweakerAPI.apply((IUndoableAction)new ClearPrereqs(key));
    }

    @ZenMethod
    public static void addSibling(String key, String sibling) {
        MineTweakerAPI.apply((IUndoableAction)new AddSibling(key, sibling));
    }

    @ZenMethod
    public static void clearSiblings(String key) {
        MineTweakerAPI.apply((IUndoableAction)new ClearSiblings(key));
    }

    @ZenMethod
    public static void setRound(String key, boolean flag) {
        MineTweakerAPI.apply((IUndoableAction)new SetResearch(key, flag, SetType.ROUND));
    }

    @ZenMethod
    public static void setSpikey(String key, boolean flag) {
        MineTweakerAPI.apply((IUndoableAction)new SetResearch(key, flag, SetType.SPIKE));
    }

    @ZenMethod
    public static void setStub(String key, boolean flag) {
        MineTweakerAPI.apply((IUndoableAction)new SetResearch(key, flag, SetType.STUB));
    }

    @ZenMethod
    public static void setSecondary(String key, boolean flag) {
        MineTweakerAPI.apply((IUndoableAction)new SetResearch(key, flag, SetType.SECONDARY));
    }

    @ZenMethod
    public static void setVirtual(String key, boolean flag) {
        MineTweakerAPI.apply((IUndoableAction)new SetResearch(key, flag, SetType.VIRTUAL));
    }

    @ZenMethod
    public static void setAutoUnlock(String key, boolean flag) {
        MineTweakerAPI.apply((IUndoableAction)new SetResearch(key, flag, SetType.AUTO));
    }

    @ZenMethod
    public static void setConcealed(String key, boolean flag) {
        MineTweakerAPI.apply((IUndoableAction)new SetResearch(key, flag, SetType.CONCEAL));
    }

    @ZenMethod
    public static void setAspects(String key, String aspects) {
        MineTweakerAPI.apply((IUndoableAction)new SetAspects(key, ThaumcraftHelper.parseAspects(aspects)));
    }

    @ZenMethod
    public static void setComplexity(String key, int complexity) {
        MineTweakerAPI.apply((IUndoableAction)new Difficulty(key, complexity));
    }

    @ZenMethod
    public static void refreshResearchRecipe(String key) {
        MineTweakerAPI.apply((IUndoableAction)new RefreshResearch(key));
    }

    @ZenMethod
    public static void moveResearch(String key, String destination, int x, int y) {
        MineTweakerAPI.apply((IUndoableAction)new MoveResearch(key, destination, x, y));
    }

    @ZenMethod
    public static boolean hasResearched(IPlayer player, String key) {
        return ThaumcraftApiHelper.isResearchComplete((String)player.getName(), (String)key);
    }

    public static enum SetType {
        AUTO,
        ROUND,
        SPIKE,
        SECONDARY,
        STUB,
        VIRTUAL,
        CONCEAL;

    }
}

