/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.helpers;

import java.util.ArrayList;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class InputHelper {
    public static boolean isABlock(IItemStack block) {
        if (!InputHelper.isABlock(InputHelper.toStack(block))) {
            MineTweakerAPI.getLogger().logError("Item must be a block, or you must specify a block to render as when adding a TConstruct Melting recipe");
            return false;
        }
        return true;
    }

    public static IItemStack[] toStacks(IIngredient[] iIngredient) {
        ArrayList<IItemStack> stacks = new ArrayList<IItemStack>();
        for (IIngredient ing : iIngredient) {
            for (IItemStack stack : ing.getItems()) {
                stacks.add(stack);
            }
        }
        IItemStack[] returnArray = new IItemStack[stacks.size()];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = (IItemStack)stacks.get(i);
        }
        return returnArray;
    }

    public static boolean isABlock(ItemStack block) {
        return block.func_77973_b() instanceof ItemBlock;
    }

    public static Entity toEntity() {
        return null;
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return null;
        }
        Object internal = iStack.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            MineTweakerAPI.getLogger().logError("Not a valid item stack: " + iStack);
        }
        return (ItemStack)internal;
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        if (iStack == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[iStack.length];
        for (int i = 0; i < iStack.length; ++i) {
            output[i] = InputHelper.toStack(iStack[i]);
        }
        return output;
    }

    public static Object toObject(IIngredient iStack) {
        if (iStack == null) {
            return null;
        }
        if (iStack instanceof IOreDictEntry) {
            return InputHelper.toString((IOreDictEntry)iStack);
        }
        if (iStack instanceof IItemStack) {
            return InputHelper.toStack((IItemStack)iStack);
        }
        return null;
    }

    public static Object[] toObjects(IIngredient[] ingredient) {
        if (ingredient == null) {
            return null;
        }
        Object[] output = new Object[ingredient.length];
        for (int i = 0; i < ingredient.length; ++i) {
            output[i] = ingredient[i] != null ? InputHelper.toObject(ingredient[i]) : "";
        }
        return output;
    }

    public static Object[] toShapedObjects(IIngredient[][] ingredients) {
        if (ingredients == null) {
            return null;
        }
        ArrayList<Object> prep = new ArrayList<Object>();
        prep.add("abc");
        prep.add("def");
        prep.add("ghi");
        char[][] map = new char[][]{{'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}};
        for (int x = 0; x < ingredients.length; ++x) {
            if (ingredients[x] == null) continue;
            for (int y = 0; y < ingredients[x].length; ++y) {
                if (ingredients[x][y] == null || x >= map.length || y >= map[x].length) continue;
                prep.add(Character.valueOf(map[x][y]));
                prep.add(InputHelper.toObject(ingredients[x][y]));
            }
        }
        return prep.toArray();
    }

    public static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    public static FluidStack toFluid(ILiquidStack iStack) {
        if (iStack == null) {
            return null;
        }
        return FluidRegistry.getFluidStack((String)iStack.getName(), (int)iStack.getAmount());
    }

    public static Fluid getFluid(ILiquidStack iStack) {
        if (iStack == null) {
            return null;
        }
        return FluidRegistry.getFluid((String)iStack.getName());
    }

    public static FluidStack[] toFluids(IIngredient[] input) {
        return InputHelper.toFluids((IIngredient[])((IItemStack[])input));
    }

    public static FluidStack[] toFluids(ILiquidStack[] iStack) {
        FluidStack[] stack = new FluidStack[iStack.length];
        for (int i = 0; i < stack.length; ++i) {
            stack[i] = InputHelper.toFluid(iStack[i]);
        }
        return stack;
    }
}

