/*
 * Decompiled with CFR 0.152.
 */
package extracells.wireless;

import appeng.api.config.Settings;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.util.IConfigManager;
import extracells.api.IWirelessFluidTermHandler;
import extracells.wireless.WirelessTermRegistry;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AEWirelessTermHandler
implements IWirelessTermHandler {
    public boolean canHandle(ItemStack is) {
        IWirelessFluidTermHandler handler = WirelessTermRegistry.getWirelessTermHandler(is);
        if (handler == null) {
            return false;
        }
        return !handler.isItemNormalWirelessTermToo(is);
    }

    public IConfigManager getConfigManager(ItemStack is) {
        return new ConfigManager();
    }

    public String getEncryptionKey(ItemStack item) {
        IWirelessFluidTermHandler handler = WirelessTermRegistry.getWirelessTermHandler(item);
        if (handler == null) {
            return null;
        }
        return handler.getEncryptionKey(item);
    }

    public boolean hasPower(EntityPlayer player, double amount, ItemStack is) {
        IWirelessFluidTermHandler handler = WirelessTermRegistry.getWirelessTermHandler(is);
        if (handler == null) {
            return false;
        }
        return handler.hasPower(player, amount, is);
    }

    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        IWirelessFluidTermHandler handler = WirelessTermRegistry.getWirelessTermHandler(item);
        if (handler == null) {
            return;
        }
        handler.setEncryptionKey(item, encKey, name);
    }

    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        IWirelessFluidTermHandler handler = WirelessTermRegistry.getWirelessTermHandler(is);
        if (handler == null) {
            return false;
        }
        return handler.usePower(player, amount, is);
    }

    private class ConfigManager
    implements IConfigManager {
        HashMap<Settings, Enum> settings = new HashMap();

        private ConfigManager() {
        }

        public Enum<?> getSetting(Settings settingName) {
            return this.settings.get(settingName);
        }

        public Set<Settings> getSettings() {
            return this.settings.keySet();
        }

        public Enum<?> putSetting(Settings settingName, Enum<?> newValue) {
            this.settings.put(settingName, newValue);
            return newValue;
        }

        public void readFromNBT(NBTTagCompound src) {
        }

        public void registerSetting(Settings settingName, Enum defaultValue) {
            this.settings.put(settingName, defaultValue);
        }

        public void writeToNBT(NBTTagCompound dest) {
        }
    }
}

