/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import extracells.integration.ni.Nei;
import extracells.integration.opencomputers.OpenComputers;
import extracells.integration.waila.Waila;
import net.minecraftforge.common.config.Configuration;

public class Integration {
    public void loadConfig(Configuration config) {
        for (Mods mod : Mods.values()) {
            mod.loadConfig(config);
        }
    }

    public void preInit() {
    }

    public void init() {
        if (Mods.WAILA.isEnabled()) {
            Waila.init();
        }
        if (Mods.OPENCOMPUTERS.isEnabled()) {
            OpenComputers.init();
        }
        if (Mods.NEI.isEnabled()) {
            Nei.init();
        }
    }

    public void postInit() {
    }

    public static enum Mods {
        WAILA("Waila"),
        OPENCOMPUTERS("OpenComputers"),
        BCFUEL("BuildCraftAPI|fuels", "BuildCraftFuel"),
        NEI("NotEnoughItems");

        private final String modID;
        private boolean shouldLoad = true;
        private final String name;

        private Mods(String modid) {
            this(modid, modid);
        }

        private Mods(String modid, String modName) {
            this.modID = modid;
            this.name = modName;
        }

        public String getModID() {
            return this.modID;
        }

        public String getModName() {
            return this.name;
        }

        public void loadConfig(Configuration config) {
            this.shouldLoad = config.get("Integration", "enable" + this.getModName(), true, "Enable " + this.getModName() + " Integration.").getBoolean(true);
        }

        public boolean isEnabled() {
            return Loader.isModLoaded((String)this.getModID()) && this.shouldLoad || ModAPIManager.INSTANCE.hasAPI(this.getModID()) && this.shouldLoad;
        }
    }
}

