/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.Charset;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public abstract class XUPacketBase {
    public abstract void writeData(ByteBuf var1) throws Exception;

    public abstract void readData(EntityPlayer var1, ByteBuf var2);

    public abstract void doStuffServer();

    @SideOnly(value=Side.CLIENT)
    public abstract void doStuffClient();

    public abstract boolean isValidSenderSide(Side var1);

    public void writeString(ByteBuf data, String string) {
        byte[] stringData = string.getBytes(Charset.forName("UTF-8"));
        data.writeShort(stringData.length);
        data.writeBytes(stringData);
    }

    public String readString(ByteBuf data) {
        short length = data.readShort();
        byte[] bytes = new byte[length];
        data.readBytes(bytes);
        return new String(bytes, Charset.forName("UTF-8"));
    }

    public void writeNBT(ByteBuf data, NBTTagCompound tag) {
        try {
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            data.writeShort(compressed.length);
            data.writeBytes(compressed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NBTTagCompound readNBT(ByteBuf data) {
        short length = data.readShort();
        byte[] bytes = new byte[length];
        data.readBytes(bytes);
        try {
            NBTTagCompound tag = CompressedStreamTools.func_152457_a((byte[])bytes, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            return tag;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

