/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericTileEntity;
import mcjty.rftools.blocks.screens.ModuleProvider;
import mcjty.rftools.blocks.screens.ScreenContainer;
import mcjty.rftools.blocks.screens.modules.ComputerScreenModule;
import mcjty.rftools.blocks.screens.modules.ScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.ClientScreenModule;
import mcjty.rftools.network.Argument;
import mcjty.rftools.network.PacketHandler;
import mcjty.rftools.network.PacketServerCommand;
import mcjty.varia.Coordinate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;

public class ScreenTileEntity
extends GenericTileEntity
implements ISidedInventory {
    public static final String CMD_CLICK = "click";
    private InventoryHelper inventoryHelper = new InventoryHelper(this, ScreenContainer.factory, 11);
    public static Map<Coordinate, Map<Integer, Object[]>> screenData = new HashMap<Coordinate, Map<Integer, Object[]>>();
    private List<ClientScreenModule> clientScreenModules = null;
    private final Map<String, List<ComputerScreenModule>> computerModules = new HashMap<String, List<ComputerScreenModule>>();
    private boolean needsServerData = false;
    private boolean powerOn = false;
    private boolean connected = false;
    private boolean large = false;
    private boolean transparent = false;
    private int color = 0;
    private List<ScreenModule> screenModules = null;
    private List<ActivatedModule> clickedModules = new ArrayList<ActivatedModule>();
    private int totalRfPerTick = 0;
    public long lastTime = 0L;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
    }

    @Override
    protected void checkStateClient() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        ArrayList<ActivatedModule> newClickedModules = new ArrayList<ActivatedModule>();
        for (ActivatedModule cm : this.clickedModules) {
            --cm.ticks;
            if (cm.ticks > 0) {
                newClickedModules.add(cm);
                continue;
            }
            List<ClientScreenModule> modules = this.getClientScreenModules();
            if (cm.module >= modules.size()) continue;
            modules.get(cm.module).mouseClick(this.field_145850_b, cm.x, cm.y, false);
        }
        this.clickedModules = newClickedModules;
    }

    @Override
    protected void checkStateServer() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        ArrayList<ActivatedModule> newClickedModules = new ArrayList<ActivatedModule>();
        for (ActivatedModule cm : this.clickedModules) {
            --cm.ticks;
            if (cm.ticks > 0) {
                newClickedModules.add(cm);
                continue;
            }
            List<ScreenModule> modules = this.getScreenModules();
            if (cm.module >= modules.size()) continue;
            modules.get(cm.module).mouseClick(this.field_145850_b, cm.x, cm.y, false);
        }
        this.clickedModules = newClickedModules;
    }

    public int[] func_94128_d(int side) {
        return ScreenContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack stack, int side) {
        return ScreenContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return ScreenContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getStacks().length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStacks()[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        this.resetModules();
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    private void resetModules() {
        this.clientScreenModules = null;
        this.screenModules = null;
        this.clickedModules.clear();
        this.computerModules.clear();
    }

    public void hitScreenClient(double hitX, double hitY, double hitZ, int side) {
        float factor = this.large ? 2.0f : 1.0f;
        float dx = 0.0f;
        float dy = (float)((-hitY + 1.0) / (double)factor);
        switch (side) {
            case 2: {
                dx = (float)((1.0 - hitX) / (double)factor);
                break;
            }
            case 3: {
                dx = (float)(hitX / (double)factor);
                break;
            }
            case 4: {
                dx = (float)(hitZ / (double)factor);
                break;
            }
            case 5: {
                dx = (float)((1.0 - hitZ) / (double)factor);
            }
        }
        int x = (int)(dx * 128.0f);
        int y = (int)(dy * 128.0f);
        int currenty = 7;
        int moduleIndex = 0;
        List<ClientScreenModule> clientScreenModules = this.getClientScreenModules();
        for (ClientScreenModule module : clientScreenModules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                if (currenty <= y && y < currenty + height) break;
                currenty += height;
            }
            ++moduleIndex;
        }
        if (moduleIndex >= clientScreenModules.size()) {
            return;
        }
        clientScreenModules.get(moduleIndex).mouseClick(this.field_145850_b, x, y - currenty, true);
        this.clickedModules.add(new ActivatedModule(moduleIndex, 5, x, y));
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketServerCommand(this.field_145851_c, this.field_145848_d, this.field_145849_e, CMD_CLICK, new Argument("x", x), new Argument("y", y - currenty), new Argument("module", moduleIndex)));
    }

    private void hitScreenServer(int x, int y, int module) {
        List<ScreenModule> screenModules = this.getScreenModules();
        ScreenModule screenModule = screenModules.get(module);
        if (screenModule != null) {
            screenModule.mouseClick(this.field_145850_b, x, y, true);
            this.clickedModules.add(new ActivatedModule(module, 5, x, y));
        }
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        this.resetModules();
    }

    public String func_145825_b() {
        return "Screen Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOn = tagCompound.func_74767_n("powerOn");
        this.connected = tagCompound.func_74767_n("connected");
        this.totalRfPerTick = tagCompound.func_74762_e("rfPerTick");
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.large = tagCompound.func_74767_n("large");
        this.transparent = tagCompound.func_74767_n("transparent");
        this.color = tagCompound.func_74762_e("color");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.getStacks()[i + 0] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
        this.resetModules();
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("powerOn", this.powerOn);
        tagCompound.func_74757_a("connected", this.connected);
        tagCompound.func_74768_a("rfPerTick", this.totalRfPerTick);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74757_a("large", this.large);
        tagCompound.func_74757_a("transparent", this.transparent);
        tagCompound.func_74768_a("color", this.color);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getStacks().length; ++i) {
            ItemStack stack = this.inventoryHelper.getStacks()[i];
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setLarge(boolean large) {
        this.large = large;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isLarge() {
        return this.large;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setPower(boolean power) {
        if (this.powerOn == power) {
            return;
        }
        this.powerOn = power;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public void setConnected(boolean c) {
        if (this.connected == c) {
            return;
        }
        this.connected = c;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void updateModuleData(int slot, NBTTagCompound tagCompound) {
        ItemStack stack = this.inventoryHelper.getStacks()[slot];
        stack.func_77982_d(tagCompound);
        this.screenModules = null;
        this.clientScreenModules = null;
        this.computerModules.clear();
        this.func_70296_d();
    }

    public List<ClientScreenModule> getClientScreenModules() {
        if (this.clientScreenModules == null) {
            this.needsServerData = false;
            this.clientScreenModules = new ArrayList<ClientScreenModule>();
            for (ItemStack itemStack : this.inventoryHelper.getStacks()) {
                if (itemStack != null && itemStack.func_77973_b() instanceof ModuleProvider) {
                    ClientScreenModule clientScreenModule;
                    ModuleProvider moduleProvider = (ModuleProvider)itemStack.func_77973_b();
                    try {
                        clientScreenModule = moduleProvider.getClientScreenModule().newInstance();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                    clientScreenModule.setupFromNBT(itemStack.func_77978_p(), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.clientScreenModules.add(clientScreenModule);
                    if (!clientScreenModule.needsServerData()) continue;
                    this.needsServerData = true;
                    continue;
                }
                this.clientScreenModules.add(null);
            }
        }
        return this.clientScreenModules;
    }

    public boolean isNeedsServerData() {
        return this.needsServerData;
    }

    public int getTotalRfPerTick() {
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.totalRfPerTick;
    }

    public List<ScreenModule> getScreenModules() {
        if (this.screenModules == null) {
            this.totalRfPerTick = 0;
            this.screenModules = new ArrayList<ScreenModule>();
            for (ItemStack itemStack : this.inventoryHelper.getStacks()) {
                if (itemStack != null && itemStack.func_77973_b() instanceof ModuleProvider) {
                    ScreenModule screenModule;
                    ModuleProvider moduleProvider = (ModuleProvider)itemStack.func_77973_b();
                    try {
                        screenModule = moduleProvider.getServerScreenModule().newInstance();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                    screenModule.setupFromNBT(itemStack.func_77978_p(), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.screenModules.add(screenModule);
                    this.totalRfPerTick += screenModule.getRfPerTick();
                    if (!(screenModule instanceof ComputerScreenModule)) continue;
                    ComputerScreenModule computerScreenModule = (ComputerScreenModule)screenModule;
                    String tag = computerScreenModule.getTag();
                    if (!this.computerModules.containsKey(tag)) {
                        this.computerModules.put(tag, new ArrayList());
                    }
                    this.computerModules.get(tag).add(computerScreenModule);
                    continue;
                }
                this.screenModules.add(null);
            }
        }
        return this.screenModules;
    }

    public List<ComputerScreenModule> getComputerModules(String tag) {
        return this.computerModules.get(tag);
    }

    public Set<String> getTags() {
        return this.computerModules.keySet();
    }

    public Map<Integer, Object[]> getScreenData(long millis) {
        HashMap<Integer, Object[]> map = new HashMap<Integer, Object[]>();
        List<ScreenModule> screenModules = this.getScreenModules();
        int moduleIndex = 0;
        for (ScreenModule module : screenModules) {
            Object[] data;
            if (module != null && (data = module.getData(this.field_145850_b, millis)) != null) {
                map.put(moduleIndex, data);
            }
            ++moduleIndex;
        }
        return map;
    }

    @Override
    public boolean execute(String command, Map<String, Argument> args) {
        boolean rc = super.execute(command, args);
        if (rc) {
            return true;
        }
        if (CMD_CLICK.equals(command)) {
            int x = args.get("x").getInteger();
            int y = args.get("y").getInteger();
            int module = args.get("module").getInteger();
            this.hitScreenServer(x, y, module);
            return true;
        }
        return false;
    }

    private static class ActivatedModule {
        int module;
        int ticks;
        int x;
        int y;

        public ActivatedModule(int module, int ticks, int x, int y) {
            this.module = module;
            this.ticks = ticks;
            this.x = x;
            this.y = y;
        }
    }
}

