/*
 * Decompiled with CFR 0.152.
 */
package lib.enderwizards.sandstone.util;

import java.util.ArrayList;
import java.util.Iterator;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryHelper {
    public static void removeItem(ItemStack stack, IInventory inventory, int quantity) {
        InventoryHelper.removeItem(stack, inventory, quantity, -1);
    }

    public static void removeItem(ItemStack stack, EntityPlayer player, int quantity) {
        InventoryHelper.removeItem(stack, (IInventory)player.field_71071_by, quantity, player.field_71071_by.field_70462_a.length);
    }

    public static void removeItem(ItemStack stack, IInventory inventory, int quantity, int limit) {
        for (int slot = 0; slot < Math.min(inventory.func_70302_i_(), limit > 0 ? limit : inventory.func_70302_i_()); ++slot) {
            ItemStack ist = inventory.func_70301_a(slot);
            if (ist == null || !inventory.func_70301_a(slot).func_77969_a(stack)) continue;
            while (quantity > 0 && inventory.func_70301_a(slot) != null) {
                inventory.func_70299_a(slot, inventory.func_70298_a(slot, 1));
                --quantity;
            }
        }
        inventory.func_70296_d();
    }

    public static ItemStack getTargetItem(ItemStack self, IInventory inventory) {
        return InventoryHelper.getTargetItem(self, inventory, true);
    }

    public static ItemStack getTargetItem(ItemStack self, IInventory inventory, boolean disposeOfItem) {
        ItemStack targetItem = null;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack == null || self.func_77969_a(stack) || stack.func_77976_d() == 1 || stack.func_77978_p() != null || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.func_77946_l();
            if (!disposeOfItem) continue;
            inventory.func_70298_a(slot, 1);
        }
        inventory.func_70296_d();
        return targetItem;
    }

    public static int getItemQuantity(ItemStack stack, IInventory inventory) {
        return InventoryHelper.getItemQuantity(stack, inventory, 0);
    }

    public static int getItemQuantity(ItemStack stack, EntityPlayer player) {
        return InventoryHelper.getItemQuantity(stack, (IInventory)player.field_71071_by, player.field_71071_by.field_70462_a.length);
    }

    public static int getItemQuantity(ItemStack stack, IInventory inventory, int limit) {
        int itemQuantity = 0;
        for (int slot = 0; slot < Math.min(inventory.func_70302_i_(), limit > 0 ? limit : inventory.func_70302_i_()); ++slot) {
            ItemStack newStack = inventory.func_70301_a(slot);
            if (newStack == null || !stack.func_77969_a(newStack)) continue;
            itemQuantity += newStack.field_77994_a;
        }
        return itemQuantity;
    }

    public static boolean consumeItem(Object item, EntityPlayer player) {
        return InventoryHelper.consumeItem(new Object[]{item}, player, 0, 1);
    }

    public static boolean consumeItem(Object item, EntityPlayer player, int minCount) {
        return InventoryHelper.consumeItem(new Object[]{item}, player, minCount, 1);
    }

    public static boolean consumeItem(Object item, EntityPlayer player, int minCount, int amountDecreased) {
        return InventoryHelper.consumeItem(new Object[]{item}, player, minCount, amountDecreased);
    }

    public static boolean consumeItem(Object[] itemList, EntityPlayer player, int minCount, int amountDecreased) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (itemList.length == 0 || !(itemList[0] instanceof ItemStack) && !(itemList[0] instanceof Item) && !(itemList[0] instanceof Block)) {
            return false;
        }
        ArrayList<Integer> suggestedSlots = new ArrayList<Integer>();
        int itemCount = 0;
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null) continue;
            ItemStack slotStack = player.field_71071_by.field_70462_a[slot];
            for (Object stack : itemList) {
                if (!(stack instanceof ItemStack && slotStack.func_77969_a((ItemStack)stack) || stack instanceof Block && ContentHelper.areItemsEqual(Item.func_150898_a((Block)((Block)stack)), slotStack.func_77973_b())) && (!(stack instanceof Item) || !ContentHelper.areItemsEqual((Item)stack, slotStack.func_77973_b()))) continue;
                itemCount += player.field_71071_by.field_70462_a[slot].field_77994_a;
                suggestedSlots.add(slot);
            }
        }
        int count = amountDecreased;
        if (suggestedSlots.size() > 0 && itemCount >= minCount + amountDecreased) {
            Iterator iterator = suggestedSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                int stackSize = player.field_71071_by.func_70301_a((int)slot).field_77994_a;
                if (stackSize >= count) {
                    player.field_71071_by.func_70298_a(slot, count);
                    return true;
                }
                player.field_71071_by.func_70298_a(slot, stackSize);
                count -= stackSize;
            }
        }
        return false;
    }
}

