/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.common.TrophyHandler;
import openblocks.common.item.ItemTrophyBlock;
import openmods.api.IActivateAwareTile;
import openmods.api.ICustomHarvestDrops;
import openmods.api.ICustomPickItem;
import openmods.api.IPlaceAwareTile;
import openmods.sync.SyncableEnum;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityTrophy
extends SyncedTileEntity
implements IPlaceAwareTile,
IActivateAwareTile,
ICustomHarvestDrops,
ICustomPickItem {
    private int cooldown = 0;
    private SyncableEnum<TrophyHandler.Trophy> trophyIndex;

    protected void createSyncedFields() {
        this.trophyIndex = new SyncableEnum((Enum)TrophyHandler.Trophy.PigZombie);
    }

    public TrophyHandler.Trophy getTrophy() {
        return (TrophyHandler.Trophy)this.trophyIndex.get();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            TrophyHandler.Trophy trophy = this.getTrophy();
            if (trophy != null) {
                trophy.executeTickBehavior(this);
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TrophyHandler.Trophy trophyType;
        if (!this.field_145850_b.field_72995_K && (trophyType = this.getTrophy()) != null) {
            trophyType.playSound(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.cooldown <= 0) {
                this.cooldown = trophyType.executeActivateBehavior(this, player);
            }
        }
        return true;
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        TrophyHandler.Trophy trophy = ItemTrophyBlock.getTrophy(stack);
        if (trophy != null) {
            this.trophyIndex.set((Enum)trophy);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.cooldown = tag.func_74762_e("cooldown");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("cooldown", this.cooldown);
    }

    public boolean suppressNormalHarvestDrops() {
        return true;
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops) {
        TrophyHandler.Trophy trophy = this.getTrophy();
        if (trophy != null) {
            drops.add(trophy.getItemStack());
        }
    }

    public ItemStack getPickBlock() {
        TrophyHandler.Trophy trophy = this.getTrophy();
        return trophy != null ? trophy.getItemStack() : null;
    }
}

