/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenGeode
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final List<WeightedRandomBlock> outline;
    private final WeightedRandomBlock[] genBlock;
    public List<WeightedRandomBlock> fillBlock = null;
    public boolean hollow = false;
    public int width = 16;
    public int height = 8;

    public WorldGenGeode(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> material, List<WeightedRandomBlock> cover) {
        this.cluster = resource;
        this.genBlock = material.toArray(new WeightedRandomBlock[material.size()]);
        this.outline = cover;
    }

    public boolean func_76484_a(World world, Random rand, int xStart, int yStart, int zStart) {
        int y;
        int x;
        int heightOff = this.height / 2;
        int widthOff = this.width / 2;
        xStart -= widthOff;
        zStart -= widthOff;
        if (yStart <= heightOff) {
            return false;
        }
        yStart -= heightOff;
        boolean[] spawnBlock = new boolean[this.width * this.width * this.height];
        boolean[] hollowBlock = new boolean[this.width * this.width * this.height];
        int W = this.width - 1;
        int H = this.height - 1;
        int e = rand.nextInt(4) + 4;
        for (int i = 0; i < e; ++i) {
            double xSize = rand.nextDouble() * 6.0 + 3.0;
            double ySize = rand.nextDouble() * 4.0 + 2.0;
            double zSize = rand.nextDouble() * 6.0 + 3.0;
            double xCenter = rand.nextDouble() * ((double)this.width - xSize - 2.0) + 1.0 + xSize / 2.0;
            double yCenter = rand.nextDouble() * ((double)this.height - ySize - 4.0) + 2.0 + ySize / 2.0;
            double zCenter = rand.nextDouble() * ((double)this.width - zSize - 2.0) + 1.0 + zSize / 2.0;
            double minDist = this.hollow ? rand.nextGaussian() * 0.15 + 0.4 : 0.0;
            for (int x2 = 1; x2 < W; ++x2) {
                for (int z = 1; z < W; ++z) {
                    for (int y2 = 1; y2 < H; ++y2) {
                        double xDist = ((double)x2 - xCenter) / (xSize / 2.0);
                        double yDist = ((double)y2 - yCenter) / (ySize / 2.0);
                        double zDist = ((double)z - zCenter) / (zSize / 2.0);
                        double dist = xDist * xDist + yDist * yDist + zDist * zDist;
                        if (dist < 1.0) {
                            boolean bl = this.hollow ? dist > minDist : (spawnBlock[(x2 * this.width + z) * this.height + y2] = true);
                        }
                        if (!this.hollow) continue;
                        hollowBlock[(x2 * this.width + z) * this.height + y2] = dist <= minDist;
                    }
                }
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                for (y = 0; y < this.height; ++y) {
                    boolean flag;
                    boolean bl = flag = this.fillBlock != null && hollowBlock[(x * this.width + z) * this.height + y] || spawnBlock[(x * this.width + z) * this.height + y] || x < W && spawnBlock[((x + 1) * this.width + z) * this.height + y] || x > 0 && spawnBlock[((x - 1) * this.width + z) * this.height + y] || z < W && spawnBlock[(x * this.width + (z + 1)) * this.height + y] || z > 0 && spawnBlock[(x * this.width + (z - 1)) * this.height + y] || y < H && spawnBlock[(x * this.width + z) * this.height + (y + 1)] || y > 0 && spawnBlock[(x * this.width + z) * this.height + (y - 1)];
                    if (!flag || WorldGenMinableCluster.canGenerateInBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock)) continue;
                    return false;
                }
            }
        }
        boolean r = false;
        for (x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                for (y = 0; y < this.height; ++y) {
                    if (!spawnBlock[(x * this.width + z) * this.height + y]) continue;
                    boolean t = WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.cluster);
                    r |= t;
                    if (t) continue;
                    spawnBlock[(x * this.width + z) * this.height + y] = false;
                }
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                for (y = 0; y < this.height; ++y) {
                    boolean flag;
                    if (this.fillBlock != null && hollowBlock[(x * this.width + z) * this.height + y]) {
                        r |= WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.fillBlock);
                        continue;
                    }
                    boolean bl = flag = !spawnBlock[(x * this.width + z) * this.height + y] && (x < W && spawnBlock[((x + 1) * this.width + z) * this.height + y] || x > 0 && spawnBlock[((x - 1) * this.width + z) * this.height + y] || z < W && spawnBlock[(x * this.width + (z + 1)) * this.height + y] || z > 0 && spawnBlock[(x * this.width + (z - 1)) * this.height + y] || y < H && spawnBlock[(x * this.width + z) * this.height + (y + 1)] || y > 0 && spawnBlock[(x * this.width + z) * this.height + (y - 1)]);
                    if (!flag) continue;
                    r |= WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.outline);
                }
            }
        }
        return r;
    }
}

