/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.ContentHelper;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import xreliquary.Reliquary;

@ContentInit
public class ItemInfernalChalice
extends ItemToggleable {
    public ItemInfernalChalice() {
        super("infernal_chalice");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        String amount = Integer.toString(NBTHelper.getInteger("fluidStacks", ist));
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"amount", (Object)amount), ist, list);
    }

    protected int fluidLimit() {
        return Reliquary.CONFIG.getInt("infernal_chalice", "fluid_limit");
    }

    @Override
    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            return super.func_77659_a(ist, world, player);
        }
        float movementThresholdCoefficient = 1.0f;
        double xOffset = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)movementThresholdCoefficient;
        double yOffset = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)movementThresholdCoefficient + 1.62 - (double)player.field_70129_M;
        double zOffset = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)movementThresholdCoefficient;
        boolean isInDrainMode = this.isEnabled(ist);
        MovingObjectPosition mop = this.func_77621_a(world, player, isInDrainMode);
        if (mop == null) {
            return ist;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            TileEntity tile;
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return ist;
            }
            if (!player.func_82247_a(x, y, z, mop.field_72310_e, ist)) {
                return ist;
            }
            if (this.isEnabled(ist) && NBTHelper.getInteger("fluidStacks", ist) + 1000 <= this.fluidLimit()) {
                tile = world.func_147438_o(x, y, z);
                if (tile instanceof IFluidHandler) {
                    FluidStack fluid = new FluidStack(FluidRegistry.LAVA, 1000);
                    FluidStack simulatedDrainedFluid = ((IFluidHandler)tile).drain(ForgeDirection.getOrientation((int)mop.field_72310_e), fluid, false);
                    if (simulatedDrainedFluid.amount == 1000) {
                        NBTHelper.setInteger("fluidStacks", ist, NBTHelper.getInteger("fluidStacks", ist) - 1000);
                    }
                    return ist;
                }
            } else {
                tile = world.func_147438_o(x, y, z);
                if (tile instanceof IFluidHandler && NBTHelper.getInteger("fluidStacks", ist) >= 1000) {
                    FluidStack fluid = new FluidStack(FluidRegistry.LAVA, 1000);
                    int amount = ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)mop.field_72310_e), fluid, false);
                    if (amount == 1000) {
                        ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)mop.field_72310_e), fluid, true);
                        NBTHelper.setInteger("fluidStacks", ist, NBTHelper.getInteger("fluidStacks", ist) - 1000);
                    }
                    return ist;
                }
            }
            String ident = ContentHelper.getIdent(world.func_147439_a(x, y, z));
            if (this.isEnabled(ist) && (ident.equals(ContentHelper.getIdent((Block)Blocks.field_150356_k)) || ident.equals(ContentHelper.getIdent(Blocks.field_150353_l))) && world.func_72805_g(x, y, z) == 0) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
                NBTHelper.setInteger("fluidStacks", ist, NBTHelper.getInteger("fluidStacks", ist) + 1000);
                return ist;
            }
            if (!this.isEnabled(ist) && NBTHelper.getInteger("fluidStacks", ist) >= 1000) {
                if (mop.field_72310_e == 0) {
                    --y;
                }
                if (mop.field_72310_e == 1) {
                    ++y;
                }
                if (mop.field_72310_e == 2) {
                    --z;
                }
                if (mop.field_72310_e == 3) {
                    ++z;
                }
                if (mop.field_72310_e == 4) {
                    --x;
                }
                if (mop.field_72310_e == 5) {
                    ++x;
                }
                if (!player.func_82247_a(x, y, z, mop.field_72310_e, ist)) {
                    return ist;
                }
                if (this.tryPlaceContainedLiquid(world, ist, xOffset, yOffset, zOffset, x, y, z) && !player.field_71075_bZ.field_75098_d) {
                    NBTHelper.setInteger("fluidStacks", ist, NBTHelper.getInteger("fluidStacks", ist) - 1000);
                    return ist;
                }
            }
        }
        return ist;
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack ist, double par2, double par4, double par6, int x, int y, int z) {
        boolean isNotSolid;
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = isNotSolid = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !isNotSolid) {
            return false;
        }
        world.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 0, 3);
        return true;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
    }
}

