/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntitySmoothMove
extends Entity {
    protected final MoveSmoother smoother;

    public EntitySmoothMove(World world) {
        super(world);
        this.smoother = this.createSmoother(world.field_72995_K);
    }

    protected MoveSmoother createSmoother(boolean isRemote) {
        return isRemote ? new MoveSmoother(0.25, 1.0, 8.0, 0.01) : new MoveSmoother(0.5, 5.0, 128.0, 0.01);
    }

    public void func_70107_b(double x, double y, double z) {
        if (this.smoother != null) {
            this.smoother.setTarget(x, y, z);
        }
        super.func_70107_b(x, y, z);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.smoother.setTarget(x, y, z);
        super.func_70080_a(x, y, z, yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int something) {
        this.smoother.setTarget(x, y, z);
        super.func_70101_b(yaw, pitch);
    }

    protected void updatePrevPosition() {
        this.field_70141_P = this.field_70140_Q;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
    }

    public class MoveSmoother {
        private final double damp;
        private final double cutoff;
        private final double panicLengthSq;
        private final double minimalLengthSq;
        private double targetX;
        private double targetY;
        private double targetZ;

        public MoveSmoother(double damp, double cutoff, double panicLength, double minimalLength) {
            this.damp = damp;
            this.cutoff = cutoff;
            this.panicLengthSq = panicLength * panicLength;
            this.minimalLengthSq = minimalLength * minimalLength;
        }

        public void setTarget(Vec3 position) {
            this.setTarget(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        }

        public void setTarget(double targetX, double targetY, double targetZ) {
            this.targetX = targetX;
            this.targetY = targetY;
            this.targetZ = targetZ;
        }

        public void update() {
            double dx = this.targetX - EntitySmoothMove.this.field_70165_t;
            double dy = this.targetY - EntitySmoothMove.this.field_70163_u;
            double dz = this.targetZ - EntitySmoothMove.this.field_70161_v;
            double lenSq = dx * dx + dy * dy + dz * dz;
            if (lenSq > this.panicLengthSq || lenSq < this.minimalLengthSq) {
                EntitySmoothMove.this.func_70107_b(this.targetX, this.targetY, this.targetZ);
                EntitySmoothMove.this.field_70179_y = 0.0;
                EntitySmoothMove.this.field_70181_x = 0.0;
                EntitySmoothMove.this.field_70159_w = 0.0;
            } else {
                if (lenSq > this.cutoff * this.cutoff) {
                    double scale = this.cutoff / Math.sqrt(lenSq);
                    dx *= scale;
                    dy *= scale;
                    dz *= scale;
                }
                EntitySmoothMove.this.func_70091_d(EntitySmoothMove.this.field_70159_w + dx * this.damp, EntitySmoothMove.this.field_70181_x + dy * this.damp, EntitySmoothMove.this.field_70179_y + dz * this.damp);
            }
        }
    }
}

