/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui.buttons;

import com.google.common.base.Splitter;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;
import thaumicenergistics.gui.buttons.AbstractButtonBase;
import thaumicenergistics.texture.AEStateIconsEnum;

public abstract class AbstractAEButton
extends AbstractButtonBase {
    private AEStateIconsEnum background = AEStateIconsEnum.REGULAR_BUTTON;
    protected AEStateIconsEnum icon;
    private int iconXPosition;
    private int iconYPosition;
    private int iconWidth;
    private int iconHeight;

    public AbstractAEButton(int ID, int xPosition, int yPosition, int width, int height, AEStateIconsEnum icon) {
        this(ID, xPosition, yPosition, width, height, icon, 0, 0, width, height, false);
    }

    public AbstractAEButton(int ID, int xPosition, int yPosition, int width, int height, AEStateIconsEnum icon, int iconXPosition, int iconYPosition, int iconWidth, int iconHeight, boolean isTab) {
        super(ID, xPosition, yPosition, width, height, "");
        this.icon = icon;
        this.iconXPosition = xPosition + iconXPosition;
        this.iconYPosition = yPosition + iconYPosition;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        if (isTab) {
            this.background = AEStateIconsEnum.TAB_BUTTON;
        }
    }

    private void drawIcon(AEStateIconsEnum icon, int xPosition, int yPosition, int width, int height) {
        this.drawScaledTexturedModalRect(xPosition, yPosition, icon.getU(), icon.getV(), width, height, icon.getWidth(), icon.getHeight());
    }

    protected void addAboutToTooltip(List<String> tooltip, String title, String text) {
        tooltip.add(EnumChatFormatting.WHITE + title);
        for (String line : Splitter.fixedLength((int)30).split((CharSequence)text)) {
            tooltip.add(EnumChatFormatting.GRAY + line);
        }
    }

    public final void func_146112_a(Minecraft minecraftInstance, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        minecraftInstance.func_110434_K().func_110577_a(AEStateIconsEnum.AE_STATES_TEXTURE);
        this.drawIcon(this.background, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
        if (this.icon != null) {
            this.drawIcon(this.icon, this.iconXPosition, this.iconYPosition, this.iconWidth, this.iconHeight);
        }
    }

    public void drawScaledTexturedModalRect(int xPosition, int yPosition, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float magic_number = 0.00390625f;
        float minU = (float)u * magic_number;
        float maxU = (float)(u + textureWidth) * magic_number;
        float minV = (float)v * magic_number;
        float maxV = (float)(v + textureHeight) * magic_number;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)xPosition, (double)(yPosition + height), (double)this.field_73735_i, (double)minU, (double)maxV);
        tessellator.func_78374_a((double)(xPosition + width), (double)(yPosition + height), (double)this.field_73735_i, (double)maxU, (double)maxV);
        tessellator.func_78374_a((double)(xPosition + width), (double)yPosition, (double)this.field_73735_i, (double)maxU, (double)minV);
        tessellator.func_78374_a((double)xPosition, (double)yPosition, (double)this.field_73735_i, (double)minU, (double)minV);
        tessellator.func_78381_a();
    }
}

