/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.lib.inventory.ComparableItemStackSafe;
import cofh.thermalexpansion.util.crafting.SmelterManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import modtweaker2.utils.BaseDescriptionAddition;
import modtweaker2.utils.BaseDescriptionRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Smelter")
public class Smelter {
    private static boolean removeValidated(ComparableItemStackSafe stack) {
        for (Map.Entry<List, SmelterManager.RecipeSmelter> entry : ThermalHelper.getSmelterMap().entrySet()) {
            SmelterManager.RecipeSmelter recipe = entry.getValue();
            if (stack.equals((Object)new ComparableItemStackSafe(recipe.getPrimaryInput()))) {
                return false;
            }
            if (!stack.equals((Object)new ComparableItemStackSafe(recipe.getSecondaryInput()))) continue;
            return false;
        }
        return ThermalHelper.smelterValid.remove(stack);
    }

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack input2, IItemStack output) {
        Smelter.addRecipe(energy, input, input2, output, null, 0);
    }

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack input2, IItemStack output, IItemStack output2, int chance) {
        ItemStack in1 = InputHelper.toStack(input);
        ItemStack in2 = InputHelper.toStack(input2);
        ItemStack out1 = InputHelper.toStack(output);
        ItemStack out2 = InputHelper.toStack(output2);
        SmelterManager.RecipeSmelter recipe = (SmelterManager.RecipeSmelter)ThermalHelper.getTERecipe(ThermalHelper.smelterRecipe, in1, in2, out1, out2, chance, energy);
        MineTweakerAPI.apply((IUndoableAction)new Add(in1, in2, recipe));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input, IItemStack input2) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(input), InputHelper.toStack(input2)));
    }

    private static class Remove
    extends BaseDescriptionRemoval {
        private final ComparableItemStackSafe input1;
        private final ComparableItemStackSafe input2;
        private final List key;
        private SmelterManager.RecipeSmelter recipe;

        public Remove(ItemStack input1, ItemStack input2) {
            super("Induction Smelter");
            this.input1 = new ComparableItemStackSafe(input1);
            this.input2 = new ComparableItemStackSafe(input2);
            this.key = Arrays.asList(this.input1, this.input2);
        }

        public void apply() {
            this.recipe = ThermalHelper.getSmelterMap().get(this.key);
            ThermalHelper.getSmelterMap().remove(this.key);
            Smelter.removeValidated(this.input1);
            Smelter.removeValidated(this.input2);
        }

        @Override
        public boolean canUndo() {
            return ThermalHelper.getSmelterMap() != null;
        }

        public void undo() {
            ThermalHelper.getSmelterMap().put(this.key, this.recipe);
            ThermalHelper.smelterValid.add(this.input1);
            ThermalHelper.smelterValid.add(this.input2);
        }

        @Override
        public String getRecipeInfo() {
            return this.input1.toItemStack().func_82833_r() + " + " + this.input2.toItemStack().func_82833_r();
        }
    }

    private static class Add
    extends BaseDescriptionAddition {
        private final ComparableItemStackSafe input1;
        private final ComparableItemStackSafe input2;
        private final List key;
        private final SmelterManager.RecipeSmelter recipe;

        public Add(ItemStack input1, ItemStack input2, SmelterManager.RecipeSmelter recipe) {
            super("Induction Smelter");
            this.input1 = new ComparableItemStackSafe(input1);
            this.input2 = new ComparableItemStackSafe(input2);
            this.key = Arrays.asList(this.input1, this.input2);
            this.recipe = recipe;
        }

        public void apply() {
            ThermalHelper.getSmelterMap().put(this.key, this.recipe);
            ThermalHelper.smelterValid.add(this.input1);
            ThermalHelper.smelterValid.add(this.input2);
        }

        @Override
        public boolean canUndo() {
            return ThermalHelper.getSmelterMap() != null;
        }

        public void undo() {
            ThermalHelper.getSmelterMap().remove(this.key);
            Smelter.removeValidated(this.input1);
            Smelter.removeValidated(this.input2);
        }

        @Override
        public String getRecipeInfo() {
            return this.recipe.getPrimaryOutput().func_82833_r();
        }
    }
}

