/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.tconstruct.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import mantle.utils.ItemMetaWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.tconstruct.TConstructHelper;
import modtweaker2.utils.BaseDescriptionAddition;
import modtweaker2.utils.BaseDescriptionRemoval;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tconstruct.library.crafting.AlloyMix;

@ZenClass(value="mods.tconstruct.Smeltery")
public class Smeltery {
    @ZenMethod
    public static void addAlloy(ILiquidStack output, ILiquidStack[] input) {
        MineTweakerAPI.apply((IUndoableAction)new AddAlloy(new AlloyMix(InputHelper.toFluid(output), new ArrayList<FluidStack>(Arrays.asList(InputHelper.toFluids(input))))));
    }

    @ZenMethod
    public static void removeAlloy(ILiquidStack output) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveAlloy(InputHelper.toFluid(output)));
    }

    @ZenMethod
    public static void addMelting(IItemStack input, ILiquidStack output, int temp, @Optional IItemStack block) {
        if (block == null) {
            block = input;
        }
        if (InputHelper.isABlock(block)) {
            Block theBlock = Block.func_149634_a((Item)InputHelper.toStack(block).func_77973_b());
            int theMeta = InputHelper.toStack(block).func_77960_j();
            MineTweakerAPI.apply((IUndoableAction)new AddMelting(InputHelper.toStack(input), theBlock, theMeta, temp, InputHelper.toFluid(output)));
        }
    }

    @ZenMethod
    public static void addMelting(IOreDictEntry input, ILiquidStack output, int temp, @Optional IItemStack block) {
        for (ItemStack stack : OreDictionary.getOres((String)input.getName())) {
            Smeltery.addMelting(MineTweakerMC.getIItemStack((ItemStack)stack), output, temp, block);
        }
    }

    @ZenMethod
    public static void removeMelting(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveMelting(InputHelper.toStack(input)));
    }

    @ZenMethod
    public static void removeMelting(IOreDictEntry input) {
        for (ItemStack stack : OreDictionary.getOres((String)input.getName())) {
            Smeltery.removeMelting(MineTweakerMC.getIItemStack((ItemStack)stack));
        }
    }

    private static class RemoveMelting
    extends BaseDescriptionRemoval {
        private final ItemStack input;
        private FluidStack fluid;
        private Integer temp;
        private ItemStack renderer;

        public RemoveMelting(ItemStack input) {
            super("Smeltery - Melting");
            this.input = input;
        }

        public void apply() {
            ItemMetaWrapper in = new ItemMetaWrapper(this.input);
            this.fluid = TConstructHelper.smeltingList.get(in);
            this.temp = TConstructHelper.temperatureList.get(in);
            this.renderer = TConstructHelper.renderIndex.get(in);
            TConstructHelper.smeltingList.remove(in);
            TConstructHelper.temperatureList.remove(in);
            TConstructHelper.renderIndex.remove(in);
        }

        public void undo() {
        }

        @Override
        public String getRecipeInfo() {
            return this.input.func_82833_r();
        }
    }

    private static class AddMelting
    extends BaseDescriptionAddition {
        private final ItemStack input;
        private final Block block;
        private final int meta;
        private final int temp;
        private final FluidStack output;

        public AddMelting(ItemStack input, Block block, int meta, int temp, FluidStack output) {
            super("Smeltery - Melting");
            this.input = input;
            this.block = block;
            this.meta = meta;
            this.temp = temp;
            this.output = output;
        }

        public void apply() {
            tconstruct.library.crafting.Smeltery.addMelting((ItemStack)this.input, (Block)this.block, (int)this.meta, (int)this.temp, (FluidStack)this.output);
        }

        public void undo() {
            ItemMetaWrapper in = new ItemMetaWrapper(this.input);
            TConstructHelper.smeltingList.remove(in);
            TConstructHelper.temperatureList.remove(in);
            TConstructHelper.renderIndex.remove(in);
        }

        @Override
        public String getRecipeInfo() {
            return this.input.func_82833_r();
        }
    }

    private static class RemoveAlloy
    extends BaseListRemoval {
        public RemoveAlloy(FluidStack output) {
            super("Smeltery - Alloy", TConstructHelper.alloys, output);
        }

        public void apply() {
            for (AlloyMix r : TConstructHelper.alloys) {
                if (r == null || r.result == null || this.fluid == null || !r.result.isFluidStackIdentical(this.fluid)) continue;
                this.recipe = r;
                break;
            }
            if (this.recipe != null) {
                TConstructHelper.alloys.remove(this.recipe);
            }
        }

        @Override
        public String getRecipeInfo() {
            return this.fluid.getFluid().getName();
        }
    }

    private static class AddAlloy
    extends BaseListAddition {
        public AddAlloy(AlloyMix recipe) {
            super("Smeltery - Alloy", TConstructHelper.alloys, recipe);
        }

        @Override
        public String getRecipeInfo() {
            return ((AlloyMix)this.recipe).result.getFluid().getName();
        }
    }
}

