/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.core.utils.ShapedRecipeCustom;
import forestry.factory.gadgets.MachineFabricator;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.ThermionicFabricator")
public class ThermionicFabricator {
    @ZenMethod
    public static void addSmelting(IItemStack itemInput, int meltingPoint, int fluidOutput) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineFabricator.Smelting(InputHelper.toStack(itemInput), FluidRegistry.getFluidStack((String)"glass", (int)fluidOutput), meltingPoint)));
    }

    @ZenMethod
    public static void removeSmelting(IItemStack itemInput) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveSmelting(InputHelper.toStack(itemInput)));
    }

    @ZenMethod
    public static void addCast(ILiquidStack fluidInput, IItemStack[][] ingredients, IItemStack plan, IItemStack product) {
        Object[] flatList = new ItemStack[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                flatList[i * 3 + j] = InputHelper.toStack(ingredients[i][j]);
            }
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineFabricator.Recipe(InputHelper.toStack(plan), InputHelper.toFluid(fluidInput), new ShapedRecipeCustom(3, 3, flatList, InputHelper.toStack(product)))));
    }

    @ZenMethod
    public static void removeCasts(IItemStack product) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveCastings(InputHelper.toStack(product)));
    }

    private static class RemoveCastings
    extends BaseListRemoval {
        public RemoveCastings(ItemStack output) {
            super("Forestry Thermionic Fabricator (Casting)", (List)MachineFabricator.RecipeManager.recipes, output);
        }

        public void apply() {
            for (MachineFabricator.Recipe r : MachineFabricator.RecipeManager.recipes) {
                if (r.asIRecipe().func_77571_b() == null || !r.asIRecipe().func_77571_b().func_77969_a(this.stack)) continue;
                this.recipe = r;
            }
            MachineFabricator.RecipeManager.recipes.remove(this.recipe);
        }

        @Override
        public String getRecipeInfo() {
            return " Output:" + this.stack.func_82833_r();
        }
    }

    private static class RemoveSmelting
    extends BaseListRemoval {
        public RemoveSmelting(ItemStack input) {
            super("Forestry Thermionic Fabricator (Smelting)", (List)MachineFabricator.RecipeManager.smeltings, input);
        }

        public void apply() {
            for (MachineFabricator.Smelting r : MachineFabricator.RecipeManager.smeltings) {
                if (r.getResource() == null || !r.getResource().func_77969_a(this.stack)) continue;
                MachineFabricator.RecipeManager.smeltings.remove(r);
                this.recipe = r;
                break;
            }
        }

        @Override
        public String getRecipeInfo() {
            return " Input:" + this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(MachineFabricator.Smelting recipe) {
            super("Forestry Thermionic Fabricator (Smelting)", MachineFabricator.RecipeManager.smeltings, recipe);
        }

        public Add(MachineFabricator.Recipe recipe) {
            super("Forestry Thermionic Fabricator (Casting)", MachineFabricator.RecipeManager.recipes, recipe);
        }

        @Override
        public String getRecipeInfo() {
            if (this.recipe instanceof MachineFabricator.Smelting) {
                return " Input:" + ((MachineFabricator.Smelting)this.recipe).getResource().func_82833_r();
            }
            return "Output: " + ((MachineFabricator.Recipe)this.recipe).asIRecipe().func_77571_b().func_82833_r();
        }
    }
}

