/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;

@Asynchronous
public class MethodsListerHelper {
    private final Map<String, IMethodExecutor> methods;
    private final Set<String> sources;

    public MethodsListerHelper(Map<String, IMethodExecutor> methods, Set<String> sources) {
        this.methods = methods;
        this.sources = sources;
    }

    @ScriptCallable(returnTypes={ReturnType.STRING}, description="List all the methods available")
    public String listMethods(@Optionals @Arg(name="filterSource") String source) {
        ArrayList info = Lists.newArrayList();
        for (Map.Entry<String, IMethodExecutor> e : this.methods.entrySet()) {
            String name = e.getKey();
            IMethodExecutor executor = e.getValue();
            IDescriptable m = executor.description();
            if (source != null && !source.equals(m.source())) continue;
            info.add(name + m.signature());
        }
        Collections.sort(info);
        return Joiner.on((String)", ").join((Iterable)info);
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="List all method sources")
    public Map<String, Boolean> listSources() {
        TreeMap result = Maps.newTreeMap();
        for (String source : this.sources) {
            result.put(source, Boolean.TRUE);
        }
        return result;
    }

    @ScriptCallable(returnTypes={ReturnType.STRING}, description="Brief description of method")
    public String doc(@Arg(name="method") String methodName) {
        IMethodExecutor method = this.methods.get(methodName);
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"Method not found");
        return method.description().doc();
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get a complete table of information about all available methods")
    public Map<?, ?> getAdvancedMethodsData(@Optionals @Arg(name="method") String methodName) {
        if (methodName != null) {
            IMethodExecutor method = this.methods.get(methodName);
            Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"Method not found");
            return method.description().describe();
        }
        HashMap info = Maps.newHashMap();
        for (Map.Entry<String, IMethodExecutor> e : this.methods.entrySet()) {
            IDescriptable m = e.getValue().description();
            info.put(e.getKey(), m.describe());
        }
        return info;
    }
}

