/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.AbstractUpgrade;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.EnergyUpgrade;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;

public class SolarUpgrade
extends AbstractUpgrade {
    private static final String KEY_LEVEL = "level";
    private static final String UPGRADE_NAME = "speedBoost";
    public static final SolarUpgrade SOLAR_ONE = new SolarUpgrade("enderio.darksteel.upgrade.solar_one", 1, Config.darkSteelSolarOneCost);
    public static final SolarUpgrade SOLAR_TWO = new SolarUpgrade("enderio.darksteel.upgrade.solar_two", 2, Config.darkSteelSolarTwoCost);
    private byte level;

    public static SolarUpgrade loadFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.field_77990_d == null) {
            return null;
        }
        if (!stack.field_77990_d.func_74764_b("enderio.darksteel.upgrade.speedBoost")) {
            return null;
        }
        return new SolarUpgrade((NBTTagCompound)stack.field_77990_d.func_74781_a("enderio.darksteel.upgrade.speedBoost"));
    }

    private static ItemStack createUpgradeItem() {
        ItemStack pot = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        int res = PotionHelper.func_77913_a((int)0, (String)Items.field_151075_bm.func_150896_i(new ItemStack(Items.field_151075_bm)));
        res = PotionHelper.func_77913_a((int)res, (String)PotionHelper.field_77922_b);
        pot.func_77964_b(res);
        return pot;
    }

    public SolarUpgrade(NBTTagCompound tag) {
        super(UPGRADE_NAME, tag);
        this.level = tag.func_74771_c(KEY_LEVEL);
    }

    public SolarUpgrade(String unlocName, byte level, int levelCost) {
        super(UPGRADE_NAME, unlocName, SolarUpgrade.createUpgradeItem(), levelCost);
        this.level = level;
    }

    @Override
    public boolean canAddToItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != DarkSteelItems.itemDarkSteelHelmet || !EnergyUpgrade.itemHasAnyPowerUpgrade(stack)) {
            return false;
        }
        SolarUpgrade up = SolarUpgrade.loadFromItem(stack);
        if (up == null) {
            return this.level == 1;
        }
        return up.level == this.level - 1;
    }

    @Override
    public boolean hasUpgrade(ItemStack stack) {
        if (!super.hasUpgrade(stack)) {
            return false;
        }
        SolarUpgrade up = SolarUpgrade.loadFromItem(stack);
        if (up == null) {
            return false;
        }
        return up.unlocName.equals(this.unlocName);
    }

    @Override
    public ItemStack getUpgradeItem() {
        return new ItemStack((Block)EnderIO.blockSolarPanel, 1, this.level - 1);
    }

    @Override
    public void writeUpgradeToNBT(NBTTagCompound upgradeRoot) {
        upgradeRoot.func_74774_a(KEY_LEVEL, this.level);
    }

    public int getRFPerSec() {
        return this.level == 1 ? Config.darkSteelSolarOneGen : Config.darkSteelSolarTwoGen;
    }
}

