/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enchantment;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.config.Config;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EnchantmentSoulBound
extends Enchantment {
    private final int id;

    public static EnchantmentSoulBound create(int id) {
        EnchantmentSoulBound res = new EnchantmentSoulBound(id);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    private EnchantmentSoulBound(int id) {
        super(id, Config.enchantmentSoulBoundWeight, EnumEnchantmentType.all);
        this.id = id;
        this.func_77322_b("enderio.soulBound");
    }

    public int func_77317_b(int level) {
        return super.func_77317_b(level) + 30;
    }

    public int func_77321_a(int level) {
        return super.func_77321_a(level);
    }

    public int func_77325_b() {
        return 1;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDropsEvent evt) {
        if (evt.entityPlayer == null || evt.entityPlayer instanceof FakePlayer) {
            return;
        }
        if (evt.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        ListIterator iter = evt.drops.listIterator();
        while (iter.hasNext()) {
            EntityItem ei = (EntityItem)iter.next();
            ItemStack item = ei.func_92059_d();
            if (!this.isSoulBound(item)) continue;
            this.addToPlayerInventory(evt.entityPlayer, item);
            iter.remove();
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        ItemStack item;
        int i;
        if (!evt.wasDeath) {
            return;
        }
        if (evt.original == null || evt.entityPlayer == null || evt.entityPlayer instanceof FakePlayer) {
            return;
        }
        if (evt.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        for (i = 0; i < evt.original.field_71071_by.field_70462_a.length; ++i) {
            item = evt.original.field_71071_by.field_70462_a[i];
            if (!this.isSoulBound(item)) continue;
            this.addToPlayerInventory(evt.entityPlayer, item);
        }
        for (i = 0; i < evt.original.field_71071_by.field_70460_b.length; ++i) {
            item = evt.original.field_71071_by.field_70460_b[i];
            if (!this.isSoulBound(item)) continue;
            this.addToPlayerInventory(evt.entityPlayer, item);
        }
    }

    private boolean isSoulBound(ItemStack item) {
        if (item == null) {
            return false;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)item);
        if (enchants != null) {
            Iterator i$ = enchants.keySet().iterator();
            while (i$.hasNext()) {
                int enchId = (Integer)i$.next();
                if (this.id != enchId) continue;
                return true;
            }
        }
        return false;
    }

    private void addToPlayerInventory(EntityPlayer entityPlayer, ItemStack item) {
        if (item == null || entityPlayer == null) {
            return;
        }
        if (item.func_77973_b() instanceof ItemArmor) {
            ItemArmor arm = (ItemArmor)item.func_77973_b();
            int index = 3 - arm.field_77881_a;
            if (entityPlayer.field_71071_by.func_70440_f(index) == null) {
                entityPlayer.field_71071_by.field_70460_b[index] = item;
                return;
            }
        }
        InventoryPlayer inv = entityPlayer.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] != null) continue;
            inv.field_70462_a[i] = item.func_77946_l();
            return;
        }
    }
}

