/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.enderstorage;

import com.google.common.base.Preconditions;
import net.minecraft.tileentity.TileEntity;
import openmods.reflection.FieldAccess;
import openmods.reflection.MethodAccess;
import openmods.reflection.ReflectionHelper;
import openmods.utils.ColorUtils;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.Alias;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.MultipleReturn;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;

public class AdapterFrequencyOwner
implements IPeripheralAdapter {
    private final Class<?> CLASS = ReflectionHelper.getClass((String)"codechicken.enderstorage.common.TileFrequencyOwner");
    private final FieldAccess<Integer> FREQ = FieldAccess.create(this.CLASS, (String[])new String[]{"freq"});
    private final MethodAccess.Function1<Void, Integer> SET_FREQ = MethodAccess.create(Void.TYPE, this.CLASS, Integer.TYPE, (String[])new String[]{"setFreq"});

    public Class<?> getTargetClass() {
        return this.CLASS;
    }

    public String getSourceId() {
        return "ender_frequency";
    }

    @Asynchronous
    @MultipleReturn
    @Alias(value={"getColours"})
    @ScriptCallable(returnTypes={ReturnType.NUMBER, ReturnType.NUMBER, ReturnType.NUMBER}, description="Get the colours active on this chest or tank")
    public int[] getColors(TileEntity frequencyOwner) {
        int frequency = (Integer)this.FREQ.get((Object)frequencyOwner);
        return new int[]{1 << (frequency >> 8 & 0xF), 1 << (frequency >> 4 & 0xF), 1 << (frequency >> 0 & 0xF)};
    }

    @Asynchronous
    @MultipleReturn
    @ScriptCallable(returnTypes={ReturnType.STRING, ReturnType.STRING, ReturnType.STRING}, description="Get the colours active on this chest or tank")
    public String[] getColorNames(TileEntity frequencyOwner) {
        int frequency = (Integer)this.FREQ.get((Object)frequencyOwner);
        return new String[]{AdapterFrequencyOwner.colorToName(frequency >> 8 & 0xF), AdapterFrequencyOwner.colorToName(frequency >> 4 & 0xF), AdapterFrequencyOwner.colorToName(frequency >> 0 & 0xF)};
    }

    @Alias(value={"setColours"})
    @ScriptCallable(description="Set the frequency of this chest or tank")
    public void setColors(TileEntity frequencyOwner, @Arg(name="color_left", description="The first color") int colorLeft, @Arg(name="color_middle", description="The second color") int colorMiddle, @Arg(name="color_right", description="The third color") int colorRight) {
        int high = AdapterFrequencyOwner.parseComputerCraftColor(colorLeft);
        int med = AdapterFrequencyOwner.parseComputerCraftColor(colorMiddle);
        int low = AdapterFrequencyOwner.parseComputerCraftColor(colorRight);
        int frequency = ((high & 0xF) << 8) + ((med & 0xF) << 4) + (low & 0xF);
        this.setFreq(frequencyOwner, frequency);
    }

    @ScriptCallable(description="Set the frequency of this chest or tank")
    public void setColorNames(TileEntity frequencyOwner, @Arg(name="color_left") String colorLeft, @Arg(name="color_middle") String colorMiddle, @Arg(name="color_right") String colorRight) {
        int high = AdapterFrequencyOwner.parseColorName(colorLeft);
        int med = AdapterFrequencyOwner.parseColorName(colorMiddle);
        int low = AdapterFrequencyOwner.parseColorName(colorRight);
        int frequency = ((high & 0xF) << 8) + ((med & 0xF) << 4) + (low & 0xF);
        this.setFreq(frequencyOwner, frequency);
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Get the frequency of this chest or tank")
    public int getFrequency(TileEntity frequencyOwner) {
        return (Integer)this.FREQ.get((Object)frequencyOwner);
    }

    @ScriptCallable(description="Set the frequency of this chest or tank")
    public void setFrequency(TileEntity frequencyOwner, @Arg(name="frequency", description="A single number that represents all three colours on this chest or tank") int frequency) {
        this.setFreq(frequencyOwner, frequency);
    }

    private void setFreq(TileEntity frequencyOwner, int frequency) {
        Preconditions.checkElementIndex((int)frequency, (int)4096, (String)"frequency");
        this.SET_FREQ.call((Object)frequencyOwner, (Object)frequency);
    }

    private static int parseComputerCraftColor(int bitmask) {
        ColorUtils.ColorMeta meta = ColorUtils.bitmaskToColor((int)bitmask);
        Preconditions.checkNotNull((Object)meta, (String)"Invalid color %sb", (Object[])new Object[]{Integer.toBinaryString(bitmask)});
        return meta.vanillaBlockId;
    }

    private static int parseColorName(String name) {
        ColorUtils.ColorMeta meta = ColorUtils.nameToColor((String)name);
        Preconditions.checkNotNull((Object)meta, (String)"Invalid color name %s", (Object[])new Object[]{name});
        return meta.vanillaBlockId;
    }

    private static String colorToName(int color) {
        ColorUtils.ColorMeta meta = ColorUtils.vanillaBlockToColor((int)color);
        Preconditions.checkNotNull((Object)meta, (String)"Invalid color id %s", (Object[])new Object[]{color});
        return meta.name;
    }
}

