/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Collapsible;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.collapsible.CollapsibleUtil;
import com.carpentersblocks.util.handler.EventHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.ItemRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersCollapsibleBlock
extends BlockCoverable {
    private static Collapsible data = new Collapsible();

    public BlockCarpentersCollapsibleBlock(Material material) {
        super(material);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int quad = Collapsible.getQuad(EventHandler.hitX, EventHandler.hitZ);
        int quadHeight = Collapsible.getQuadHeight(TE, quad);
        Collapsible.setQuadHeight(TE, quad, --quadHeight);
        this.smoothAdjacentCollapsibles(TE, quad);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int quad = Collapsible.getQuad(EventHandler.hitX, EventHandler.hitZ);
        int quadHeight = Collapsible.getQuadHeight(TE, quad);
        Collapsible.setQuadHeight(TE, quad, ++quadHeight);
        this.smoothAdjacentCollapsibles(TE, quad);
        return true;
    }

    @Override
    protected void damageItemWithChance(World world, EntityPlayer entityPlayer) {
        if ((double)world.field_73012_v.nextFloat() <= ItemRegistry.itemHammerDamageChanceFromCollapsible) {
            super.damageItemWithChance(world, entityPlayer);
        }
    }

    private void smoothAdjacentCollapsibles(TEBase TE, int src_quadrant) {
        World world = TE.func_145831_w();
        TEBase TE_XN = this.getTileEntity((IBlockAccess)world, TE.field_145851_c - 1, TE.field_145848_d, TE.field_145849_e);
        TEBase TE_XP = this.getTileEntity((IBlockAccess)world, TE.field_145851_c + 1, TE.field_145848_d, TE.field_145849_e);
        TEBase TE_ZN = this.getTileEntity((IBlockAccess)world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e - 1);
        TEBase TE_ZP = this.getTileEntity((IBlockAccess)world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e + 1);
        TEBase TE_XZNN = this.getTileEntity((IBlockAccess)world, TE.field_145851_c - 1, TE.field_145848_d, TE.field_145849_e - 1);
        TEBase TE_XZNP = this.getTileEntity((IBlockAccess)world, TE.field_145851_c - 1, TE.field_145848_d, TE.field_145849_e + 1);
        TEBase TE_XZPN = this.getTileEntity((IBlockAccess)world, TE.field_145851_c + 1, TE.field_145848_d, TE.field_145849_e - 1);
        TEBase TE_XZPP = this.getTileEntity((IBlockAccess)world, TE.field_145851_c + 1, TE.field_145848_d, TE.field_145849_e + 1);
        int height = Collapsible.getQuadHeight(TE, src_quadrant);
        switch (src_quadrant) {
            case 0: {
                if (TE_ZN != null) {
                    Collapsible.setQuadHeight(TE_ZN, 1, height);
                }
                if (TE_XZNN != null) {
                    Collapsible.setQuadHeight(TE_XZNN, 3, height);
                }
                if (TE_XN == null) break;
                Collapsible.setQuadHeight(TE_XN, 2, height);
                break;
            }
            case 1: {
                if (TE_XN != null) {
                    Collapsible.setQuadHeight(TE_XN, 3, height);
                }
                if (TE_XZNP != null) {
                    Collapsible.setQuadHeight(TE_XZNP, 2, height);
                }
                if (TE_ZP == null) break;
                Collapsible.setQuadHeight(TE_ZP, 0, height);
                break;
            }
            case 2: {
                if (TE_XP != null) {
                    Collapsible.setQuadHeight(TE_XP, 0, height);
                }
                if (TE_XZPN != null) {
                    Collapsible.setQuadHeight(TE_XZPN, 1, height);
                }
                if (TE_ZN == null) break;
                Collapsible.setQuadHeight(TE_ZN, 3, height);
                break;
            }
            case 3: {
                if (TE_ZP != null) {
                    Collapsible.setQuadHeight(TE_ZP, 2, height);
                }
                if (TE_XZPP != null) {
                    Collapsible.setQuadHeight(TE_XZPP, 0, height);
                }
                if (TE_XP == null) break;
                Collapsible.setQuadHeight(TE_XP, 1, height);
            }
        }
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        float maxHeight = CollapsibleUtil.getBoundsMaxHeight(TE);
        if (maxHeight != 1.0f) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, maxHeight, 1.0f);
        }
    }

    public boolean isSideSolid(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection side) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null && this.isBlockSolid(blockAccess, x, y, z)) {
            switch (side) {
                case UP: {
                    return TE.getData() == 0;
                }
                case NORTH: {
                    return Collapsible.getQuadHeight(TE, 0) + Collapsible.getQuadHeight(TE, 2) == 32;
                }
                case SOUTH: {
                    return Collapsible.getQuadHeight(TE, 1) + Collapsible.getQuadHeight(TE, 3) == 32;
                }
                case WEST: {
                    return Collapsible.getQuadHeight(TE, 1) + Collapsible.getQuadHeight(TE, 0) == 32;
                }
                case EAST: {
                    return Collapsible.getQuadHeight(TE, 2) + Collapsible.getQuadHeight(TE, 3) == 32;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isSlopeBoundary(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            return true;
        }
        return world.func_147439_a(x, y, z).func_149688_o().func_76230_c() || !world.func_147439_a(x, y - 1, z).func_149688_o().func_76230_c();
    }

    private int scanX(World world, int x, int y, int z, int dir, int maxDist) {
        for (int nx = x + dir; nx != x + maxDist * dir; nx += dir) {
            if (!this.isSlopeBoundary(world, nx, y, z)) continue;
            return nx;
        }
        return x + dir;
    }

    private int scanZ(World world, int x, int y, int z, int dir, int maxDist) {
        for (int nz = z + dir; nz != z + maxDist * dir; nz += dir) {
            if (!this.isSlopeBoundary(world, x, y, nz)) continue;
            return nz;
        }
        return z + dir;
    }

    private static int getBlockHeight(IBlockAccess blockAccess, int x, int y, int z) {
        Block block = blockAccess.func_147439_a(x, y, z);
        if (!block.func_149688_o().func_76230_c()) {
            return 1;
        }
        return (int)(block.func_149669_A() * 15.0 + 1.0);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE;
        if (!entityLiving.func_70093_af() && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            int hzp2;
            int hzp1;
            int hzn2;
            int hzn1;
            int hxp2;
            int hxp1;
            int hxn2;
            int hxn1;
            boolean MIN_HEIGHT = true;
            int MAX_HEIGHT = 16;
            int xn = this.scanX(world, x, y, z, -1, 16);
            int xp = this.scanX(world, x, y, z, 1, 16);
            int zn = this.scanZ(world, x, y, z, -1, 16);
            int zp = this.scanZ(world, x, y, z, 1, 16);
            TEBase TE_XN = this.getTileEntity((IBlockAccess)world, xn, y, z);
            TEBase TE_XP = this.getTileEntity((IBlockAccess)world, xp, y, z);
            TEBase TE_ZN = this.getTileEntity((IBlockAccess)world, x, y, zn);
            TEBase TE_ZP = this.getTileEntity((IBlockAccess)world, x, y, zp);
            int height_XZNN = 1;
            int height_XZPN = 1;
            int height_XZPP = 1;
            int height_XZNP = 1;
            if (TE_XN != null) {
                hxn1 = Collapsible.getQuadHeight(TE_XN, 2);
                hxn2 = Collapsible.getQuadHeight(TE_XN, 3);
            } else {
                hxn1 = hxn2 = BlockCarpentersCollapsibleBlock.getBlockHeight((IBlockAccess)world, xn, y, z);
            }
            if (TE_XP != null) {
                hxp1 = Collapsible.getQuadHeight(TE_XP, 0);
                hxp2 = Collapsible.getQuadHeight(TE_XP, 1);
            } else {
                hxp1 = hxp2 = BlockCarpentersCollapsibleBlock.getBlockHeight((IBlockAccess)world, xp, y, z);
            }
            if (TE_ZN != null) {
                hzn1 = Collapsible.getQuadHeight(TE_ZN, 1);
                hzn2 = Collapsible.getQuadHeight(TE_ZN, 3);
            } else {
                hzn1 = hzn2 = BlockCarpentersCollapsibleBlock.getBlockHeight((IBlockAccess)world, x, y, zn);
            }
            if (TE_ZP != null) {
                hzp1 = Collapsible.getQuadHeight(TE_ZP, 0);
                hzp2 = Collapsible.getQuadHeight(TE_ZP, 2);
            } else {
                hzp1 = hzp2 = BlockCarpentersCollapsibleBlock.getBlockHeight((IBlockAccess)world, x, y, zp);
            }
            int xdist = x - xn;
            double dx1 = (double)(hxp1 - hxn1) / (double)(xp - xn - 1);
            double dx2 = (double)(hxp2 - hxn2) / (double)(xp - xn - 1);
            height_XZNN = Math.max(height_XZNN, (int)((double)hxn1 + dx1 * (double)(xdist - 1)));
            height_XZNP = Math.max(height_XZNP, (int)((double)hxn2 + dx2 * (double)(xdist - 1)));
            height_XZPN = Math.max(height_XZPN, (int)((double)hxn1 + dx1 * (double)xdist));
            height_XZPP = Math.max(height_XZPP, (int)((double)hxn2 + dx2 * (double)xdist));
            int zdist = z - zn;
            double dz1 = (double)(hzp1 - hzn1) / (double)(zp - zn - 1);
            double dz2 = (double)(hzp2 - hzn2) / (double)(zp - zn - 1);
            height_XZNN = Math.max(height_XZNN, (int)((double)hzn1 + dz1 * (double)(zdist - 1)));
            height_XZNP = Math.max(height_XZNP, (int)((double)hzn1 + dz1 * (double)zdist));
            height_XZPN = Math.max(height_XZPN, (int)((double)hzn2 + dz2 * (double)(zdist - 1)));
            height_XZPP = Math.max(height_XZPP, (int)((double)hzn2 + dz2 * (double)zdist));
            Collapsible.setQuadHeight(TE, 0, height_XZNN);
            Collapsible.setQuadHeight(TE, 1, height_XZNP);
            Collapsible.setQuadHeight(TE, 3, height_XZPP);
            Collapsible.setQuadHeight(TE, 2, height_XZPN);
            for (int quad = 0; quad < 4; ++quad) {
                this.smoothAdjacentCollapsibles(TE, quad);
            }
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            AxisAlignedBB colBox = null;
            for (int quad = 0; quad < 4; ++quad) {
                float[] bounds = CollapsibleUtil.genBounds(TE, quad);
                colBox = AxisAlignedBB.func_72330_a((double)((float)x + bounds[0]), (double)((float)y + bounds[1]), (double)((float)z + bounds[2]), (double)((float)x + bounds[3]), (double)((float)y + bounds[4]), (double)((float)z + bounds[5]));
                if (!axisAlignedBB.func_72326_a(colBox)) continue;
                list.add(colBox);
            }
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        MovingObjectPosition finalTrace = null;
        if (TE != null) {
            double currDist = 0.0;
            double maxDist = 0.0;
            for (int quad = 0; quad < 4; ++quad) {
                float[] bounds = CollapsibleUtil.genBounds(TE, quad);
                this.func_149676_a(bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5]);
                MovingObjectPosition traceResult = super.func_149731_a(world, x, y, z, startVec, endVec);
                if (traceResult == null || !((currDist = traceResult.field_72307_f.func_72436_e(endVec)) > maxDist)) continue;
                finalTrace = traceResult;
                maxDist = currDist;
            }
            if (finalTrace != null) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                finalTrace = super.func_149731_a(world, x, y, z, startVec, endVec);
            }
        }
        return finalTrace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean shareFaces(TEBase TE_adj, TEBase TE_src, ForgeDirection side_adj, ForgeDirection side_src) {
        if (TE_adj.func_145838_q() != this) return super.shareFaces(TE_adj, TE_src, side_adj, side_src);
        switch (side_adj) {
            case NORTH: {
                if (Collapsible.getQuadHeight(TE_adj, 0) != Collapsible.getQuadHeight(TE_src, 1)) return false;
                if (Collapsible.getQuadHeight(TE_adj, 2) != Collapsible.getQuadHeight(TE_src, 3)) return false;
                return true;
            }
            case SOUTH: {
                if (Collapsible.getQuadHeight(TE_adj, 1) != Collapsible.getQuadHeight(TE_src, 0)) return false;
                if (Collapsible.getQuadHeight(TE_adj, 3) != Collapsible.getQuadHeight(TE_src, 2)) return false;
                return true;
            }
            case WEST: {
                if (Collapsible.getQuadHeight(TE_adj, 1) != Collapsible.getQuadHeight(TE_src, 3)) return false;
                if (Collapsible.getQuadHeight(TE_adj, 0) != Collapsible.getQuadHeight(TE_src, 2)) return false;
                return true;
            }
            case EAST: {
                if (Collapsible.getQuadHeight(TE_adj, 3) != Collapsible.getQuadHeight(TE_src, 1)) return false;
                if (Collapsible.getQuadHeight(TE_adj, 2) != Collapsible.getQuadHeight(TE_src, 0)) return false;
                return true;
            }
        }
        return super.shareFaces(TE_adj, TE_src, side_adj, side_src);
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersCollapsibleBlockRenderID;
    }
}

