/*
 * Decompiled with CFR 0.152.
 */
package me.exz.wailanbt.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import me.exz.wailanbt.handler.NBTHandler;
import me.exz.wailanbt.util.LogHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class config {
    public static JsonObject configJson;
    public static File modConfigurationDirectory;
    private static File configDir;

    public static void init(File dir, EntityPlayer player) {
        configDir = new File(dir, "WailaNBT");
        if (!configDir.exists()) {
            try {
                configDir.mkdir();
                File defaultFile = new File(configDir, "default.json");
                defaultFile.createNewFile();
                LogHelper.info("Empty config created");
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("wailanbt.info.CreateEmptyConfig", new Object[0]));
            }
            catch (Exception e) {
                LogHelper.info("Create config file failed");
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("wailanbt.info.FailCreateEmptyConfig", new Object[0]));
                e.printStackTrace();
            }
        }
        config.loadConfig(player);
    }

    public static void loadConfig(EntityPlayer player) {
        configJson = new JsonObject();
        NBTHandler.manager = new ScriptEngineManager(null);
        NBTHandler.engine = NBTHandler.manager.getEngineByName("javascript");
        NBTHandler.scriptSet = new HashSet();
        try {
            NBTHandler.engine.eval("var names={}");
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        for (Object item : Item.field_150901_e) {
            String ID = String.valueOf(Item.field_150901_e.func_148757_b(item));
            String name = StatCollector.func_74838_a((String)(((Item)item).func_77658_a() + ".name")).trim();
            try {
                NBTHandler.engine.eval("names['" + ID + "']='" + name + "'");
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
        File[] configFiles = configDir.listFiles();
        if (configFiles != null) {
            for (File configFile : configFiles) {
                if (!configFile.isFile()) continue;
                try {
                    FileInputStream inputStream = new FileInputStream(configFile);
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    JsonParser parser = new JsonParser();
                    JsonElement jsonElementCurrent = parser.parse((Reader)inputStreamReader);
                    if (jsonElementCurrent.isJsonObject()) {
                        JsonObject jsonObjectCurrent = jsonElementCurrent.getAsJsonObject();
                        config.mergeJson(jsonObjectCurrent);
                        continue;
                    }
                    LogHelper.error("Parse " + configFile.getName() + " failed");
                    player.func_146105_b((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"wailanbt.info.JsonContentError"), configFile.getName())));
                }
                catch (Exception e) {
                    LogHelper.error("Error parsing file '" + configFile.getName() + "'. Possible error: " + e.getCause().getMessage());
                    player.func_146105_b((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"wailanbt.info.ParsingError"), configFile.getName())));
                }
            }
        }
        LogHelper.info("Config Loaded");
        System.out.println(configJson);
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("wailanbt.info.ConfigLoaded", new Object[0]));
    }

    private static void mergeJson(JsonObject jsonObjectCurrent) {
        Set holdItemA = jsonObjectCurrent.entrySet();
        try {
            for (Map.Entry holdItem : holdItemA) {
                if (configJson.has((String)holdItem.getKey())) {
                    JsonObject configJsonHoldItem = configJson.get((String)holdItem.getKey()).getAsJsonObject();
                    Set teA = ((JsonElement)holdItem.getValue()).getAsJsonObject().entrySet();
                    for (Map.Entry te : teA) {
                        if (configJsonHoldItem.has((String)te.getKey())) continue;
                        configJsonHoldItem.add((String)te.getKey(), (JsonElement)te.getValue());
                    }
                    configJson.remove((String)holdItem.getKey());
                    configJson.add((String)holdItem.getKey(), (JsonElement)configJsonHoldItem);
                    continue;
                }
                configJson.add((String)holdItem.getKey(), (JsonElement)holdItem.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

