/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import appeng.api.config.AccessRestriction;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import extracells.api.ECApi;
import extracells.api.IWirelessFluidTermHandler;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy")
public class ItemWirelessTerminalFluid
extends Item
implements IWirelessFluidTermHandler,
IAEItemPowerStorage,
IEnergyContainerItem {
    IIcon icon;
    private final int MAX_POWER = 3200000;

    public ItemWirelessTerminalFluid() {
        this.func_77625_d(1);
        ECApi.instance().registerWirelessFluidTermHandler(this);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        String encryptionKey = itemStack.func_77978_p().func_74779_i("key");
        double aeCurrentPower = this.getAECurrentPower(itemStack);
        list.add(StatCollector.func_74838_a((String)"gui.appliedenergistics2.StoredEnergy") + ": " + aeCurrentPower + " AE - " + Math.floor(aeCurrentPower / (double)this.MAX_POWER * 10000.0) / 100.0 + "%");
        list.add(StatCollector.func_74838_a((String)(encryptionKey != null && !encryptionKey.isEmpty() ? "gui.appliedenergistics2.Linked" : "gui.appliedenergistics2.Unlinked")));
    }

    @Override
    public boolean canHandle(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() == this;
    }

    private NBTTagCompound ensureTagCompound(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public double extractAEPower(ItemStack itemStack, double amt) {
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toExtract = Math.min(amt, currentPower);
        tagCompound.func_74780_a("power", currentPower - toExtract);
        return toExtract;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container == null) {
            return 0;
        }
        if (simulate) {
            return this.getEnergyStored(container) >= maxExtract ? maxExtract : this.getEnergyStored(container);
        }
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.extractAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxExtract)));
    }

    public double getAECurrentPower(ItemStack itemStack) {
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        return tagCompound.func_74769_h("power");
    }

    public double getAEMaxPower(ItemStack itemStack) {
        return this.MAX_POWER;
    }

    public int getDamage(ItemStack itemStack) {
        return (int)this.getAECurrentPower(itemStack);
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - this.getAECurrentPower(itemStack) / (double)this.MAX_POWER;
    }

    public String getEncryptionKey(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p().func_74779_i("key");
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(arg0));
    }

    public IIcon func_77617_a(int dmg) {
        return this.icon;
    }

    public int getMaxDamage(ItemStack itemStack) {
        return this.MAX_POWER;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(arg0));
    }

    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        return null;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List itemList) {
        itemList.add(new ItemStack(item));
        ItemStack itemStack = new ItemStack(item);
        this.injectAEPower(itemStack, this.MAX_POWER);
        itemList.add(itemStack);
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack).replace("item.extracells", "extracells.item");
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amount, ItemStack is) {
        return this.getAECurrentPower(is) >= amount;
    }

    public double injectAEPower(ItemStack itemStack, double amt) {
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toInject = Math.min(amt, (double)this.MAX_POWER - currentPower);
        tagCompound.func_74780_a("power", currentPower + toInject);
        return toInject;
    }

    @Override
    public boolean isItemNormalWirelessTermToo(ItemStack is) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        return ECApi.instance().openWirelessTerminal(entityPlayer, itemStack, world);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container == null) {
            return 0;
        }
        if (simulate) {
            double current = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(container));
            double max = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(container));
            if (max - current >= (double)maxReceive) {
                return maxReceive;
            }
            return (int)(max - current);
        }
        int notStored = (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.injectAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxReceive)));
        return maxReceive - notStored;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("extracells:terminal.fluid.wireless");
    }

    public void setEncryptionKey(ItemStack itemStack, String encKey, String name) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        tagCompound.func_74778_a("key", encKey);
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        this.extractAEPower(is, amount);
        return true;
    }
}

