/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.render;

import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.client.model.DragonModel;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBreedRegistry;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStageHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class DragonRenderer
extends RenderLiving {
    public static final String TEX_BASE = "textures/entities/dragon/";
    public static final String MDL_BASE = "models/entities/dragon/";
    public static boolean updateModel;
    private final Map<DragonBreed, DragonModel> breedModels = new HashMap<DragonBreed, DragonModel>();
    private final ResourceLocation dissolveTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/dissolve.png");
    private final ResourceLocation eggTexture = new ResourceLocation(DragonMounts.AID, "models/entities/dragon/dragon_egg.obj");
    private final IModelCustom eggModel = AdvancedModelLoader.loadModel((ResourceLocation)this.eggTexture);
    private DragonModel dragonModel;

    public DragonRenderer() {
        super(null, 2.0f);
        this.initBreedModels();
    }

    private void initBreedModels() {
        this.breedModels.clear();
        for (DragonBreed breed : DragonBreedRegistry.getInstance().getBreeds()) {
            this.breedModels.put(breed, new DragonModel(breed));
        }
    }

    private void setModel(DragonBreed breed) {
        this.dragonModel = this.breedModels.get(breed);
        this.field_77046_h = this.dragonModel;
        this.field_77045_g = this.dragonModel;
    }

    public void func_76986_a(EntityLiving entity, double x, double y, double z, float yaw, float partialTicks) {
        this.doRender((EntityTameableDragon)entity, x, y, z, yaw, partialTicks);
    }

    public void doRender(EntityTameableDragon dragon, double x, double y, double z, float yaw, float partialTicks) {
        this.setModel(dragon.getBreed());
        this.passSpecialRender2((EntityLivingBase)dragon, x, y, z);
        if (dragon.isEgg()) {
            this.renderEgg(dragon, x, y, z, yaw, partialTicks);
        } else {
            super.func_76986_a((EntityLiving)dragon, x, y, z, yaw, partialTicks);
        }
    }

    protected void func_77036_a(EntityLivingBase entity, float moveTime, float moveSpeed, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        this.renderModel((EntityTameableDragon)entity, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
    }

    protected void renderModel(EntityTameableDragon dragon, float moveTime, float moveSpeed, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        this.dragonModel.renderPass = -1;
        if (dragon.getDeathTime() > 0) {
            float alpha = (float)dragon.getDeathTime() / (float)dragon.getMaxDeathTime();
            GL11.glDepthFunc((int)515);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)alpha);
            this.func_110776_a(this.dissolveTexture);
            this.dragonModel.render(dragon, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthFunc((int)514);
        }
        super.func_77036_a((EntityLivingBase)dragon, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
    }

    protected void renderEgg(EntityTameableDragon dragon, double x, double y, double z, float pitch, float partialTicks) {
        DragonLifeStageHelper lifeStage = dragon.getLifeStageHelper();
        float tickX = lifeStage.getEggWiggleX();
        float tickZ = lifeStage.getEggWiggleZ();
        float rotX = 0.0f;
        float rotZ = 0.0f;
        if (tickX > 0.0f) {
            rotX = (float)Math.sin(tickX - partialTicks) * 8.0f;
        }
        if (tickZ > 0.0f) {
            rotZ = (float)Math.sin(tickZ - partialTicks) * 8.0f;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_110776_a(this.dragonModel.getEggTexture());
        this.eggModel.renderAll();
        GL11.glPopMatrix();
    }

    public int func_77032_a(EntityLivingBase entity, int pass, float scale) {
        return this.shouldRenderPass((EntityTameableDragon)entity, pass, scale);
    }

    public int shouldRenderPass(EntityTameableDragon dragon, int pass, float scale) {
        if (pass == 0 && updateModel && dragon.field_70173_aa % 20 == 0) {
            this.initBreedModels();
        }
        this.dragonModel.renderPass = pass;
        switch (pass) {
            case 0: {
                if (!dragon.isSaddled()) break;
                this.func_110776_a(this.dragonModel.saddleTexture);
                return 1;
            }
            case 1: {
                this.func_110776_a(this.dragonModel.glowTexture);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                GL11.glDisable((int)2896);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)65536.0f, (float)0.0f);
                return 1;
            }
            case 2: {
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
            }
        }
        return -1;
    }

    protected void func_77043_a(EntityLivingBase par1EntityLiving, float par2, float par3, float par4) {
        this.rotateCorpse((EntityTameableDragon)par1EntityLiving, par2, par3, par4);
    }

    protected void rotateCorpse(EntityTameableDragon dragon, float par2, float par3, float par4) {
        GL11.glRotatef((float)(180.0f - par3), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected void func_77041_b(EntityLivingBase entity, float partialTicks) {
        this.preRenderCallback((EntityTameableDragon)entity, partialTicks);
    }

    protected void preRenderCallback(EntityTameableDragon dragon, float partialTicks) {
        float scale = dragon.getScale() * 0.8f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getEntityTexture((EntityTameableDragon)entity);
    }

    protected ResourceLocation getEntityTexture(EntityTameableDragon dragon) {
        return this.dragonModel.bodyTexture;
    }

    protected void func_77033_b(EntityLivingBase entity, double x, double y, double z) {
    }

    protected void passSpecialRender2(EntityLivingBase par1EntityLiving, double par2, double par4, double par6) {
        super.func_77033_b(par1EntityLiving, par2, par4, par6);
    }
}

