/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import tterrag.core.common.config.AbstractConfigHandler;
import tterrag.core.common.config.PacketConfigSync;
import tterrag.core.common.config.annot.Comment;
import tterrag.core.common.config.annot.Config;
import tterrag.core.common.config.annot.NoSync;
import tterrag.core.common.config.annot.Range;
import tterrag.core.common.config.annot.RestartReq;
import tterrag.core.common.event.ConfigFileChangedEvent;
import tterrag.core.common.network.TTPacketHandler;

public class ConfigProcessor {
    static final Map<String, ConfigProcessor> processorMap = Maps.newHashMap();
    String modid;
    private Class<?> configs;
    private Configuration configFile;
    private IReloadCallback callback;
    Map<String, Object> configValues = Maps.newHashMap();
    private Set<String> sections = Sets.newHashSet();

    public ConfigProcessor(Class<?> configs, File configFile, String modid) {
        this(configs, configFile, modid, null);
    }

    public ConfigProcessor(Class<?> configs, File configFile, String modid, IReloadCallback callback) {
        this(configs, new Configuration(configFile), modid, callback);
    }

    public ConfigProcessor(Class<?> configs, AbstractConfigHandler handler) {
        this(configs, handler, null);
    }

    public ConfigProcessor(Class<?> configs, AbstractConfigHandler handler, IReloadCallback callback) {
        this(configs, handler.config, handler.modid, callback);
    }

    private ConfigProcessor(Class<?> configs, Configuration configFile, String modid, IReloadCallback callback) {
        this.configs = configs;
        this.configFile = configFile;
        this.modid = modid;
        this.callback = callback;
        processorMap.put(modid, this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void process(boolean load) {
        if (load) {
            this.configFile.load();
        }
        try {
            for (Field f : this.configs.getDeclaredFields()) {
                this.processField(f);
            }
            if (this.callback != null) {
                this.callback.callback(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.configFile.save();
    }

    private boolean processField(Field f) throws Exception {
        Config cfg = f.getAnnotation(Config.class);
        if (cfg == null) {
            return false;
        }
        Object value = f.get(null);
        Object newValue = this.getConfigValue(cfg.value(), this.getComment(f), f, value);
        this.configValues.put(f.getName(), newValue);
        f.set(null, newValue);
        this.sections.add(cfg.value());
        return !value.equals(newValue);
    }

    private Object getConfigValue(String section, String comment, Field f, Object defVal) {
        Property prop = null;
        Object ret = null;
        AbstractConfigHandler.Bound<Double> bound = this.getBound(f);
        if (defVal instanceof Boolean) {
            prop = this.configFile.get(section, f.getName(), ((Boolean)defVal).booleanValue(), comment);
            ret = prop.getBoolean();
        } else if (defVal instanceof Integer) {
            prop = this.configFile.get(section, f.getName(), ((Integer)defVal).intValue(), comment);
            ret = AbstractConfigHandler.boundValue(prop, AbstractConfigHandler.Bound.of(((Double)bound.min).intValue(), ((Double)bound.max).intValue()), (Integer)defVal);
        } else if (defVal instanceof Double) {
            prop = this.configFile.get(section, f.getName(), ((Double)defVal).doubleValue(), comment);
            ret = AbstractConfigHandler.boundValue(prop, AbstractConfigHandler.Bound.of(Double.valueOf((Double)bound.min), Double.valueOf((Double)bound.max)), (Double)defVal);
        } else if (defVal instanceof String) {
            prop = this.configFile.get(section, f.getName(), (String)defVal, comment);
            ret = prop.getString();
        } else if (defVal instanceof String[]) {
            prop = this.configFile.get(section, f.getName(), (String[])defVal, comment);
            ret = prop.getStringList();
        }
        AbstractConfigHandler.setBounds(prop, bound);
        this.getRestartReq(f).apply(prop);
        return ret;
    }

    public ImmutableSet<String> sections() {
        return ImmutableSet.copyOf(this.sections);
    }

    public ConfigCategory getCategory(String category) {
        return this.configFile.getCategory(category);
    }

    public void syncTo(Map<String, Object> values) {
        this.configValues = values;
        for (String s : this.configValues.keySet()) {
            try {
                Field f = this.configs.getDeclaredField(s);
                Config annot = f.getAnnotation(Config.class);
                if (annot == null || this.getNoSync(f)) continue;
                Object newVal = this.configValues.get(s);
                boolean changed = false;
                if (!f.get(null).equals(newVal)) {
                    f.set(null, newVal);
                    changed = true;
                }
                if (!changed || this.callback == null) continue;
                this.callback.callback(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getComment(Field f) {
        Comment c = f.getAnnotation(Comment.class);
        return c == null ? "" : c.value();
    }

    private AbstractConfigHandler.Bound<Double> getBound(Field f) {
        Range r = f.getAnnotation(Range.class);
        return r == null ? AbstractConfigHandler.Bound.MAX_BOUND : AbstractConfigHandler.Bound.of(r.min(), r.max());
    }

    private boolean getNoSync(Field f) {
        return f.getAnnotation(NoSync.class) != null;
    }

    private AbstractConfigHandler.RestartReqs getRestartReq(Field f) {
        RestartReq r = f.getAnnotation(RestartReq.class);
        return r == null ? AbstractConfigHandler.RestartReqs.NONE : r.value();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        TTPacketHandler.INSTANCE.sendTo((IMessage)new PacketConfigSync(this), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(this.modid)) {
            this.process(false);
        }
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.modID.equals(this.modid)) {
            this.process(true);
        }
    }

    public static interface IReloadCallback {
        public void callback(ConfigProcessor var1);
    }
}

