/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.oc;

import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Node;
import openperipheral.adapter.IMethodCall;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.converter.IConverter;
import openperipheral.converter.TypeConvertersProvider;
import openperipheral.interfaces.oc.ModuleOpenComputers;

public class OpenComputersEnv {
    public static IArchitectureAccess createAccess(final Node ownNode, final Context context) {
        return new IArchitectureAccess(){

            @Override
            public String architecture() {
                return "OpenComputers";
            }

            @Override
            public String callerName() {
                return context.node().address();
            }

            @Override
            public String peripheralName() {
                return ownNode.address();
            }

            @Override
            public boolean signal(String name, Object ... args) {
                return context.signal(name, args);
            }

            @Override
            public Object wrapObject(Object target) {
                return ModuleOpenComputers.wrapObject(target);
            }
        };
    }

    public static IMethodCall addCommonArgs(IMethodCall call, Context context) {
        IConverter converter = TypeConvertersProvider.INSTANCE.getConverter("OpenComputers");
        return call.setOptionalArg("converter", converter).setOptionalArg("context", context);
    }

    public static IMethodCall addPeripheralArgs(IMethodCall call, Node node, Context context) {
        IArchitectureAccess wrappedAccess = OpenComputersEnv.createAccess(node, context);
        return OpenComputersEnv.addCommonArgs(call, context).setOptionalArg("access", wrappedAccess);
    }
}

