/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import openmods.Log;
import openperipheral.adapter.wrappers.AdapterWrapper;
import openperipheral.adapter.wrappers.ExternalAdapterWrapper;
import openperipheral.adapter.wrappers.InlineAdapterWrapper;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.IAdapter;
import openperipheral.api.adapter.IAdapterWithConstraints;
import openperipheral.api.peripheral.PeripheralTypeId;

public class AdapterRegistry {
    public static final AdapterRegistry PERIPHERAL_ADAPTERS = new AdapterRegistry();
    public static final AdapterRegistry OBJECT_ADAPTERS = new AdapterRegistry();
    private final Multimap<Class<?>, AdapterWrapper> externalAdapters = HashMultimap.create();
    private final Map<Class<?>, AdapterWrapper> internalAdapters = Maps.newHashMap();

    public Map<Class<?>, Collection<AdapterWrapper>> listExternalAdapters() {
        return Collections.unmodifiableMap(this.externalAdapters.asMap());
    }

    public Map<Class<?>, AdapterWrapper> listInternalAdapters() {
        return Collections.unmodifiableMap(this.internalAdapters);
    }

    public boolean addAdapter(IAdapter adapter) {
        AdapterWrapper wrapper;
        try {
            wrapper = this.wrapExternalAdapter(adapter);
        }
        catch (Throwable e) {
            Log.warn((Throwable)e, (String)"Something went terribly wrong while adding internal adapter '%s'. It will be disabled", (Object[])new Object[]{adapter.getClass()});
            return false;
        }
        Class<?> targetCls = adapter.getTargetClass();
        Preconditions.checkArgument((!Object.class.equals(targetCls) ? 1 : 0) != 0, (Object)"Can't add adapter for Object class");
        Log.trace((String)"Registering %s adapter (source id: %s) for %s", (Object[])new Object[]{wrapper.describe(), wrapper.source(), targetCls});
        this.externalAdapters.put(targetCls, (Object)wrapper);
        return true;
    }

    public void addInlineAdapter(Class<?> targetCls) {
        AdapterWrapper wrapper = this.wrapInlineAdapter(targetCls);
        Log.trace((String)"Registering %s adapter (source id: %s) adapter for %s", (Object[])new Object[]{wrapper.describe(), wrapper.source(), targetCls});
        this.internalAdapters.put(targetCls, wrapper);
    }

    public Collection<AdapterWrapper> getExternalAdapters(Class<?> targetCls) {
        return Collections.unmodifiableCollection(this.externalAdapters.get(targetCls));
    }

    public AdapterWrapper getInlineAdapter(Class<?> targetCls) {
        AdapterWrapper wrapper = this.internalAdapters.get(targetCls);
        if (wrapper == null) {
            wrapper = this.wrapInlineAdapter(targetCls);
            this.internalAdapters.put(targetCls, wrapper);
        }
        return wrapper;
    }

    protected AdapterWrapper wrapExternalAdapter(IAdapter adapter) {
        return adapter instanceof IAdapterWithConstraints ? new ExternalAdapterWrapper.WithConstraints((IAdapterWithConstraints)adapter) : new ExternalAdapterWrapper(adapter);
    }

    protected AdapterWrapper wrapInlineAdapter(Class<?> targetClass) {
        return new InlineAdapterWrapper(targetClass, AdapterRegistry.getSourceId(targetClass));
    }

    private static String getSourceId(Class<?> cls) {
        Annotation id = cls.getAnnotation(AdapterSourceName.class);
        if (id != null) {
            return id.value();
        }
        if (TileEntity.class.isAssignableFrom(cls) && (id = cls.getAnnotation(PeripheralTypeId.class)) != null) {
            return id.value();
        }
        Log.trace((String)"Inline adapter %s has no @AdapterSourceName annotation", (Object[])new Object[]{cls});
        return cls.getName().toLowerCase();
    }
}

