/*
 * Decompiled with CFR 0.152.
 */
package openeye.asm;

import java.util.Collection;
import openeye.Log;
import openeye.asm.MethodCodeInjector;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class SingleClassTransformer
extends ClassVisitor {
    private final Collection<MethodCodeInjector> methodInjectors;

    public SingleClassTransformer(ClassVisitor cv, String obfClassName, Collection<MethodCodeInjector> injectors) {
        super(262144, cv);
        this.methodInjectors = injectors;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        for (MethodCodeInjector injector : this.methodInjectors) {
            if (!injector.matcher.match(name, desc)) continue;
            Log.info("Applying method transformer %s for method %s(%s)", injector.name, name, desc);
            return injector.createVisitor(parent);
        }
        return parent;
    }
}

