/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.block.BlockSided;
import com.carpentersblocks.data.Lever;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersLever
extends BlockSided {
    private static Lever data = new Lever();

    public BlockCarpentersLever(Material material) {
        super(material, data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_lever = iconRegister.func_94245_a("CarpentersBlocks:lever/lever");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return IconRegistry.icon_lever;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int polarity = data.getPolarity(TE) == 0 ? 1 : 0;
        data.setPolarity(TE, polarity);
        this.notifyBlocksOfPowerChange(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        if (polarity == 0) {
            ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
        } else {
            ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
        }
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int meta = world.func_72805_g(x, y, z);
            if (meta < 2) {
                ForgeDirection dir = EntityLivingUtil.getFacing(entityLiving);
                if (dir.equals((Object)ForgeDirection.NORTH) || dir.equals((Object)ForgeDirection.SOUTH)) {
                    data.setAxis(TE, Lever.Axis.Z);
                }
            } else if (meta == ForgeDirection.NORTH.ordinal() || meta == ForgeDirection.SOUTH.ordinal()) {
                data.setAxis(TE, Lever.Axis.Z);
            }
        }
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            ForgeDirection side = data.getDirection(TE);
            Lever.Axis axis = data.getAxis(TE);
            float offset = 0.1875f;
            switch (side) {
                case DOWN: {
                    if (axis.equals((Object)Lever.Axis.X)) {
                        this.func_149676_a(0.2f, 1.0f - offset, 0.5f - offset, 0.8f, 1.0f, 0.5f + offset);
                        break;
                    }
                    this.func_149676_a(0.5f - offset, 1.0f - offset, 0.2f, 0.5f + offset, 1.0f, 0.8f);
                    break;
                }
                case UP: {
                    if (axis.equals((Object)Lever.Axis.X)) {
                        this.func_149676_a(0.2f, 0.0f, 0.5f - offset, 0.8f, offset, 0.5f + offset);
                        break;
                    }
                    this.func_149676_a(0.5f - offset, 0.0f, 0.2f, 0.5f + offset, offset, 0.8f);
                    break;
                }
                default: {
                    this.setBlockBounds(0.5f - offset, 0.2f, 0.0f, 0.5f + offset, 0.8f, offset, side);
                }
            }
        }
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        data.setState(TE, this.isActive(TE) ? 0 : 1, true);
        World world = TE.func_145831_w();
        world.func_147459_d(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, (Block)this);
        this.notifyBlocksOfPowerChange(world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        actionResult.setAltered().setNoSound();
    }

    private boolean isActive(TEBase TE) {
        return data.getState(TE) == 1;
    }

    @Override
    public int getPowerOutput(TEBase TE) {
        if (this.isActive(TE)) {
            return data.getPolarity(TE) == 0 ? 15 : 0;
        }
        return data.getPolarity(TE) == 1 ? 15 : 0;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && this.isActive(TE)) {
            world.func_147459_d(x, y, z, block);
            this.notifyBlocksOfPowerChange(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersLeverRenderID;
    }
}

