/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectSourceHelper;
import thaumcraft.common.entities.golems.EntityGolemBase;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.InventoryCraftingCachedResult;
import tuhljin.automagy.network.MessageGUIGolemWorkbenchRecipe;
import tuhljin.automagy.tiles.ModTileEntityWithInventory;

public class TileEntityGolemWorkbench
extends ModTileEntityWithInventory {
    public static final int EMPTY_CORE = 1;
    public static int CRAFTING_TIME = 20;
    public static int NUM_COMPONENT_SLOTS = 9;
    public static int CRAFTINGHEAT_MAX = 12000;
    public static int CRAFTINGHEAT_SLOWER = 1200;
    public EntityGolemBase currentGolem = null;
    public ItemStack currentRecipeOutput = null;
    public int progress = 0;
    public boolean recipeIsAdvanced = false;
    public int craftingHeat = 0;
    public InventoryCraftingCachedResult invCrafting;
    private int ticks = 0;
    EntitySelectorCraftingGolem entitySelectorCraftingGolem = new EntitySelectorCraftingGolem();

    public TileEntityGolemWorkbench() {
        super("blockGolemWorkbench", NUM_COMPONENT_SLOTS);
        this.invCrafting = new InventoryCraftingCachedResult("Golem Crafting Inventory");
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.ticks = this.field_145850_b.field_73012_v.nextInt(20);
        }
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return stack == null || !this.invCrafting.containsItem(stack);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_145845_h() {
        ItemStack result;
        if (this.field_145850_b.field_72995_K) return;
        ++this.ticks;
        if (this.craftingHeat > 0) {
            --this.craftingHeat;
        } else if (this.craftingHeat < 0 && this.currentGolem == null && this.ticks % 5 == 0) {
            ++this.craftingHeat;
        }
        if (!(this.currentRecipeOutput == null && this.ticks % 20 != 0 || ItemStack.func_77989_b((ItemStack)this.currentRecipeOutput, (ItemStack)(result = this.getCraftingResult())))) {
            HashMap<HashableItemWithoutSize, Integer> map;
            this.currentRecipeOutput = result;
            this.currentGolem = null;
            this.progress = 0;
            this.ticks = 4;
            this.recipeIsAdvanced = false;
            if (this.currentRecipeOutput != null && (map = this.invCrafting.getItemMap()).size() > 1) {
                boolean bl = this.recipeIsAdvanced = !this.invCrafting.recipeFitsSmallGrid();
            }
        }
        if (this.currentRecipeOutput == null) {
            return;
        }
        if (!this.containsAllIngredients()) {
            return;
        }
        double grabRange = 3.0;
        if (this.currentGolem == null) {
            if (this.ticks % 4 != 0) return;
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - grabRange), (double)((double)this.field_145848_d - grabRange), (double)((double)this.field_145849_e - grabRange), (double)((double)this.field_145851_c + grabRange + 1.0), (double)((double)this.field_145848_d + grabRange), (double)((double)this.field_145849_e + grabRange + 1.0));
            List entities = this.field_145850_b.func_82733_a(EntityGolemBase.class, box, (IEntitySelector)this.entitySelectorCraftingGolem);
            for (EntityGolemBase golem : entities) {
                if (this.recipeIsAdvanced && !golem.advanced || !ThaumcraftExtension.canGolemTake(golem, this.currentRecipeOutput)) continue;
                this.currentGolem = golem;
                this.progress = 0;
                break;
            }
            if (this.currentGolem == null) {
                return;
            }
        } else if (!this.entitySelectorCraftingGolem.func_82704_a((Entity)this.currentGolem) || !ThaumcraftExtension.canGolemTake(this.currentGolem, this.currentRecipeOutput) || TjUtil.getDistanceBetweenPoints_double(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.currentGolem.field_70165_t, this.currentGolem.field_70163_u, this.currentGolem.field_70161_v) > grabRange) {
            this.currentGolem = null;
            this.progress = 0;
            return;
        }
        if (this.craftingHeat > CRAFTINGHEAT_SLOWER && AspectSourceHelper.drainEssentia((TileEntity)this, (Aspect)Aspect.CRAFT, (ForgeDirection)ForgeDirection.UNKNOWN, (int)8)) {
            this.craftingHeat = -700;
        }
        float goal = CRAFTING_TIME;
        if (this.craftingHeat > CRAFTINGHEAT_SLOWER && (goal *= 1.5f * ((float)this.craftingHeat / (float)CRAFTINGHEAT_SLOWER)) > 200.0f) {
            goal = 200.0f;
        }
        if ((float)this.progress < goal) {
            if (this.currentGolem.field_70159_w == 0.0 && Math.abs(this.currentGolem.field_70181_x) < 0.1 && this.currentGolem.field_70179_y == 0.0) {
                ++this.progress;
                this.craftingHeat += 5;
                if (this.ticks % (this.craftingHeat < CRAFTINGHEAT_SLOWER ? 6 : 20) == 0) {
                    if (this.field_145850_b.field_73012_v.nextBoolean()) {
                        this.currentGolem.startRightArmTimer();
                    } else {
                        this.currentGolem.startLeftArmTimer();
                    }
                    this.ticks = this.field_145850_b.field_73012_v.nextInt(3) + 2;
                }
                if (this.craftingHeat > CRAFTINGHEAT_SLOWER + 5) {
                    this.currentGolem.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 2));
                }
            }
        } else {
            ItemStack leftover = ThaumcraftExtension.giveItemToGolem(this.currentGolem, this.currentRecipeOutput);
            if (leftover != null) {
                TjUtil.dropItemIntoWorld(leftover, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.consumeCraftingIngredients();
            this.progress = 0;
            this.ticks = 0;
            this.craftingHeat += 50;
            this.field_145850_b.func_72956_a((Entity)this.currentGolem, "random.pop", 0.1f, ((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 1.5f);
        }
        if (this.craftingHeat <= CRAFTINGHEAT_MAX) return;
        this.craftingHeat = CRAFTINGHEAT_MAX;
    }

    public void func_145834_a(World w) {
        super.func_145834_a(w);
        this.invCrafting.setWorld(w);
    }

    public ItemStack getCraftingResult() {
        return this.invCrafting.getCraftingResult();
    }

    public boolean containsAllIngredients() {
        HashMap<HashableItemWithoutSize, Integer> map = this.invCrafting.getItemMap();
        FilteringItemList list = new FilteringItemList().populateFromInventory((IInventory)this, false);
        for (Map.Entry<HashableItemWithoutSize, Integer> entry : map.entrySet()) {
            HashableItemWithoutSize item = entry.getKey();
            int num = entry.getValue();
            if (list.get(item) >= num) continue;
            return false;
        }
        return true;
    }

    public void consumeCraftingIngredients() {
        block0: for (int craftSlot = 0; craftSlot < 9; ++craftSlot) {
            ItemStack ingredient = this.invCrafting.func_70301_a(craftSlot);
            if (ingredient == null) continue;
            for (int slot = 0; slot < NUM_COMPONENT_SLOTS; ++slot) {
                ItemStack stack = this.func_70301_a(slot);
                if (!TjUtil.areItemsEqualIgnoringSize(ingredient, stack)) continue;
                this.func_70298_a(slot, 1);
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                if (container != null && container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) continue block0;
                if (!stack.func_77973_b().func_77630_h(stack) && this.func_70301_a(slot) == null) {
                    this.func_70299_a(slot, container);
                    continue block0;
                }
                if (container == null) continue block0;
                TjUtil.dropItemIntoWorld(container, this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                continue block0;
            }
        }
    }

    public void clientSendRecipeToServer(ItemStack[] stacks) {
        MessageGUIGolemWorkbenchRecipe.sendToServer(this, stacks);
    }

    public void receiveRecipeFromClient(ItemStack[] stacks) {
        if (stacks == null || stacks.length != this.inventorySlots.length) {
            FMLLog.warning((String)"[Automagy] TileEntityGolemWorkbench received invalid packet data. Ignoring.", (Object[])new Object[0]);
            return;
        }
        for (int i = 0; i < stacks.length; ++i) {
            this.invCrafting.func_70299_a(i, stacks[i]);
        }
        this.func_70296_d();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.craftingHeat = nbttagcompound.func_74762_e("craftingHeat");
        this.invCrafting.readCustomNBT(nbttagcompound);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74768_a("craftingHeat", this.craftingHeat);
        this.invCrafting.writeCustomNBT(nbttagcompound);
    }

    public class EntitySelectorCraftingGolem
    implements IEntitySelector {
        public boolean func_82704_a(Entity entity) {
            EntityGolemBase golem = (EntityGolemBase)entity;
            if (!golem.inactive && !golem.paused && golem.getCore() == 1 && golem.getCarried() == null) {
                ChunkCoordinates coord = golem.func_110172_bL();
                ForgeDirection dir = ForgeDirection.getOrientation((int)golem.homeFacing);
                if (dir != ForgeDirection.UNKNOWN && coord.field_71574_a == TileEntityGolemWorkbench.this.field_145851_c + dir.offsetX && coord.field_71572_b == TileEntityGolemWorkbench.this.field_145848_d + dir.offsetY && coord.field_71573_c == TileEntityGolemWorkbench.this.field_145849_e + dir.offsetZ) {
                    return true;
                }
            }
            return false;
        }
    }
}

