/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.xp;

import crazypants.enderio.EnderIO;
import crazypants.enderio.xp.XpUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class ExperienceContainer {
    private int experienceLevel;
    private float experience;
    private int experienceTotal;
    private boolean xpDirty;
    private final int maxXp;

    public ExperienceContainer() {
        this(Integer.MAX_VALUE);
    }

    public ExperienceContainer(int maxStored) {
        this.maxXp = maxStored;
    }

    public int getMaximumExperiance() {
        return this.maxXp;
    }

    public int getExperienceLevel() {
        return this.experienceLevel;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getExperienceTotal() {
        return this.experienceTotal;
    }

    public boolean isDirty() {
        return this.xpDirty;
    }

    public void setDirty(boolean isDirty) {
        this.xpDirty = isDirty;
    }

    public void set(ExperienceContainer xpCon) {
        this.experienceTotal = xpCon.experienceTotal;
        this.experienceLevel = xpCon.experienceLevel;
        this.experience = xpCon.experience;
    }

    public int addExperience(int xpToAdd) {
        int j = this.maxXp - this.experienceTotal;
        if (xpToAdd > j) {
            xpToAdd = j;
        }
        this.experience += (float)xpToAdd / (float)this.getXpBarCapacity();
        this.experienceTotal += xpToAdd;
        while (this.experience >= 1.0f) {
            this.experience = (this.experience - 1.0f) * (float)this.getXpBarCapacity();
            ++this.experienceLevel;
            this.experience /= (float)this.getXpBarCapacity();
        }
        this.xpDirty = true;
        return xpToAdd;
    }

    private int getXpBarCapacity() {
        return XpUtil.getXpBarCapacity(this.experienceLevel);
    }

    public int getXpBarScaled(int scale) {
        int result = (int)(this.experience * (float)scale);
        return result;
    }

    public void givePlayerXp(EntityPlayer player, int levels) {
        for (int i = 0; i < levels && this.experienceTotal > 0; ++i) {
            this.givePlayerXpLevel(player);
        }
    }

    public void givePlayerXpLevel(EntityPlayer player) {
        int currentXP = XpUtil.getPlayerXP(player);
        int nextLevelXP = XpUtil.getExperienceForLevel(player.field_71068_ca + 1) + 1;
        int requiredXP = nextLevelXP - currentXP;
        requiredXP = Math.min(this.experienceTotal, requiredXP);
        player.func_71023_q(requiredXP);
        int newXp = this.experienceTotal - requiredXP;
        this.experience = 0.0f;
        this.experienceLevel = 0;
        this.experienceTotal = 0;
        this.addExperience(newXp);
    }

    public void drainPlayerXpToReachContainerLevel(EntityPlayer player, int level) {
        int targetXP = XpUtil.getExperienceForLevel(level);
        int requiredXP = targetXP - this.experienceTotal;
        if (requiredXP <= 0) {
            return;
        }
        int drainXP = Math.min(requiredXP, XpUtil.getPlayerXP(player));
        this.addExperience(drainXP);
        XpUtil.addPlayerXP(player, -drainXP);
    }

    public void drainPlayerXpToReachPlayerLevel(EntityPlayer player, int level) {
        int targetXP = XpUtil.getExperienceForLevel(level);
        int drainXP = XpUtil.getPlayerXP(player) - targetXP;
        if (drainXP <= 0) {
            return;
        }
        if ((drainXP = this.addExperience(drainXP)) > 0) {
            XpUtil.addPlayerXP(player, -drainXP);
        }
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (EnderIO.fluidXpJuice == null) {
            return null;
        }
        int available = this.getFluidAmount();
        int canDrain = Math.min(available, maxDrain);
        if (doDrain) {
            int newXp = this.experienceTotal - XpUtil.liquidToExperiance(canDrain);
            this.experience = 0.0f;
            this.experienceLevel = 0;
            this.experienceTotal = 0;
            this.addExperience(newXp);
        }
        return new FluidStack(EnderIO.fluidXpJuice, canDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && EnderIO.fluidXpJuice != null && fluid.getID() == EnderIO.fluidXpJuice.getID();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int xpSpace;
        if (resource == null) {
            return 0;
        }
        if (resource.amount <= 0) {
            return 0;
        }
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int xp = XpUtil.liquidToExperiance(resource.amount);
        int canFillXP = Math.min(xp, xpSpace = this.getMaximumExperiance() - this.getExperienceTotal());
        if (canFillXP <= 0) {
            return 0;
        }
        if (doFill) {
            this.addExperience(canFillXP);
        }
        return XpUtil.experienceToLiquid(canFillXP);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid != null && EnderIO.fluidXpJuice != null && fluid.getID() == EnderIO.fluidXpJuice.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (EnderIO.fluidXpJuice == null) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(EnderIO.fluidXpJuice, this.getFluidAmount()), this.getMaxFluidAmount())};
    }

    private int getMaxFluidAmount() {
        if (this.maxXp == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return XpUtil.experienceToLiquid(this.maxXp);
    }

    private int getFluidAmount() {
        return XpUtil.experienceToLiquid(this.experienceTotal);
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        this.experienceLevel = nbtRoot.func_74762_e("experienceLevel");
        this.experienceTotal = nbtRoot.func_74762_e("experienceTotal");
        this.experience = nbtRoot.func_74760_g("experience");
    }

    public void writeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74768_a("experienceLevel", this.experienceLevel);
        nbtRoot.func_74768_a("experienceTotal", this.experienceTotal);
        nbtRoot.func_74776_a("experience", this.experience);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.experienceTotal);
        buf.writeInt(this.experienceLevel);
        buf.writeFloat(this.experience);
    }

    public void fromBytes(ByteBuf buf) {
        this.experienceTotal = buf.readInt();
        this.experienceLevel = buf.readInt();
        this.experience = buf.readFloat();
    }
}

