/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.BlockConduitBundle;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.util.BlockCoord;
import crazypants.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractItemConduit
extends Item
implements IConduitItem {
    protected ModObject modObj;
    protected ItemConduitSubtype[] subtypes;
    protected IIcon[] icons;

    protected AbstractItemConduit(ModObject modObj) {
        this.modObj = modObj;
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(modObj.unlocalisedName);
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    protected void init(ItemConduitSubtype[] subtypes) {
        this.subtypes = subtypes;
        this.icons = new IIcon[subtypes.length];
        GameRegistry.registerItem((Item)this, (String)this.modObj.unlocalisedName);
    }

    public void func_94581_a(IIconRegister IIconRegister2) {
        int index = 0;
        for (ItemConduitSubtype subtype : this.subtypes) {
            this.icons[index] = IIconRegister2.func_94245_a(subtype.iconKey);
            ++index;
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        BlockCoord placeAt = Util.canPlaceItem(stack, EnderIO.blockConduitBundle, player, world, x, y, z, side);
        if (placeAt != null) {
            TileEntity te;
            if (!world.field_72995_K && world.func_147465_d(placeAt.x, placeAt.y, placeAt.z, (Block)EnderIO.blockConduitBundle, 0, 1) && (te = world.func_147438_o(placeAt.x, placeAt.y, placeAt.z)) instanceof IConduitBundle) {
                IConduitBundle bundle = (IConduitBundle)te;
                bundle.addConduit(this.createConduit(stack, player));
                BlockConduitBundle b = EnderIO.blockConduitBundle;
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), b.field_149762_H.func_150498_e(), (b.field_149762_H.func_150497_c() + 1.0f) / 2.0f, b.field_149762_H.func_150494_d() * 0.8f);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        ForgeDirection dir = ForgeDirection.values()[side];
        int placeX = x + dir.offsetX;
        int placeY = y + dir.offsetY;
        int placeZ = z + dir.offsetZ;
        if (world.func_147439_a(placeX, placeY, placeZ) == EnderIO.blockConduitBundle) {
            TileConduitBundle bundle = (TileConduitBundle)world.func_147438_o(placeX, placeY, placeZ);
            if (bundle == null) {
                System.out.println("AbstractItemConduit.onItemUse: Bundle null");
                return false;
            }
            if (!bundle.hasType(this.getBaseConduitType())) {
                if (!world.field_72995_K) {
                    IConduit con = this.createConduit(stack, player);
                    if (con == null) {
                        System.out.println("AbstractItemConduit.onItemUse: Conduit null.");
                        return false;
                    }
                    bundle.addConduit(con);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public IIcon func_77617_a(int damage) {
        damage = MathHelper.func_76125_a((int)damage, (int)0, (int)(this.subtypes.length - 1));
        return this.icons[damage];
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int i = MathHelper.func_76125_a((int)par1ItemStack.func_77960_j(), (int)0, (int)(this.subtypes.length - 1));
        return this.subtypes[i].unlocalisedName;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < this.subtypes.length; ++j) {
            par3List.add(new ItemStack((Item)this, 1, j));
        }
    }
}

