/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.world.feature.FeatureBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureGenCave
extends FeatureBase {
    final WorldGenerator worldGen;
    final int count;
    final boolean ceiling;

    public FeatureGenCave(String name, WorldGenerator worldGen, boolean ceiling, int count, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.ceiling = ceiling;
    }

    @Override
    protected boolean generateFeature(Random random, int chunkX, int chunkZ, World world) {
        int averageSeaLevel = world.field_73011_w.func_76557_i() + 1;
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        boolean generated = false;
        for (int i = 0; i < this.count; ++i) {
            Block block;
            int stopY;
            int z;
            int x = blockX + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            int seaLevel = averageSeaLevel;
            if (seaLevel < 20) {
                seaLevel = world.func_72976_f(x, z);
            }
            int y = stopY = random.nextInt(1 + seaLevel / 2);
            while (!(block = world.func_147439_a(x, y, z)).isAir((IBlockAccess)world, x, y, z) && ++y < seaLevel) {
            }
            if (y == seaLevel) {
                y = 0;
                while (!(block = world.func_147439_a(x, y, z)).isAir((IBlockAccess)world, x, y, z) && ++y < stopY) {
                }
                if (y == stopY) continue;
            }
            if (this.ceiling) {
                if (y < stopY) {
                    seaLevel = stopY + 1;
                }
                do {
                    block = world.func_147439_a(x, ++y, z);
                } while (y < seaLevel && block.isAir((IBlockAccess)world, x, y, z));
                if (y == seaLevel) continue;
                --y;
            } else if (block.isAir((IBlockAccess)world, x, y - 1, z)) {
                --y;
                while ((block = world.func_147439_a(x, y, z)).isAir((IBlockAccess)world, x, y, z) && y-- > 0) {
                }
                if (y == -1) continue;
                ++y;
            }
            generated |= this.worldGen.func_76484_a(world, random, x, y, z);
        }
        return generated;
    }
}

