/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.api.fluid.ITankContainerBucketable;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.position.BlockPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class UtilLiquidMover {
    public static boolean manuallyFillTank(ITankContainerBucketable itcb, EntityPlayer player) {
        Item item;
        IFluidContainerItem fluidContainer;
        ItemStack ci = player.field_71071_by.func_70448_g();
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ci);
        if (liquid != null) {
            Item item2 = ci.func_77973_b();
            if (itcb.fill(ForgeDirection.UNKNOWN, liquid, false) == liquid.amount) {
                itcb.fill(ForgeDirection.UNKNOWN, liquid, true);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (item2.hasContainerItem(ci)) {
                        ItemStack drop = item2.getContainerItem(ci);
                        if (drop != null && drop.func_77984_f() && drop.func_77960_j() > drop.func_77958_k()) {
                            drop = null;
                        }
                        ItemHelper.disposePlayerItem(ci, drop, player, true);
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemHelper.consumeItem(ci, player));
                    }
                    if (!player.field_70170_p.field_72995_K) {
                        player.field_71070_bA.func_75142_b();
                        ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                    }
                }
                return true;
            }
        } else if (ci != null && ci.func_77973_b() instanceof IFluidContainerItem && itcb.fill(ForgeDirection.UNKNOWN, liquid = (fluidContainer = (IFluidContainerItem)(item = ci.func_77973_b())).getFluid(ci), false) > 0) {
            int amount = itcb.fill(ForgeDirection.UNKNOWN, liquid, true);
            ItemStack drop = ci.func_77979_a(1);
            ++ci.field_77994_a;
            fluidContainer.drain(drop, amount, true);
            if (!player.field_71075_bZ.field_75098_d) {
                if (item.hasContainerItem(drop) && (drop = item.getContainerItem(drop)) != null && drop.func_77984_f() && drop.func_77960_j() > drop.func_77958_k()) {
                    drop = null;
                }
                ItemHelper.disposePlayerItem(ci, drop, player, true);
                if (!player.field_70170_p.field_72995_K) {
                    player.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                }
            }
            return true;
        }
        return false;
    }

    public static boolean manuallyDrainTank(ITankContainerBucketable itcb, EntityPlayer player) {
        ItemStack ci = player.field_71071_by.func_70448_g();
        boolean isSmartContainer = false;
        if (ci != null && (FluidContainerRegistry.isEmptyContainer((ItemStack)ci) || (isSmartContainer = ci.func_77973_b() instanceof IFluidContainerItem))) {
            for (FluidTankInfo tank : itcb.getTankInfo(ForgeDirection.UNKNOWN)) {
                FluidStack tankLiquid = tank.fluid;
                if (tankLiquid == null || tankLiquid.amount == 0) continue;
                ItemStack filledBucket = null;
                FluidStack bucketLiquid = null;
                if (isSmartContainer) {
                    IFluidContainerItem fluidContainer = (IFluidContainerItem)ci.func_77973_b();
                    filledBucket = ci.func_77946_l();
                    filledBucket.field_77994_a = 1;
                    if (fluidContainer.fill(filledBucket, tankLiquid, false) > 0) {
                        int amount = fluidContainer.fill(filledBucket, tankLiquid, true);
                        bucketLiquid = new FluidStack(tankLiquid.fluidID, amount);
                        FluidStack l = itcb.drain(ForgeDirection.UNKNOWN, bucketLiquid, false);
                        if (l == null || l.amount < amount) {
                            filledBucket = null;
                        }
                    } else {
                        filledBucket = null;
                    }
                } else {
                    filledBucket = FluidContainerRegistry.fillFluidContainer((FluidStack)tankLiquid, (ItemStack)ci);
                    if (FluidContainerRegistry.isFilledContainer((ItemStack)filledBucket)) {
                        bucketLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledBucket);
                        FluidStack l = itcb.drain(ForgeDirection.UNKNOWN, bucketLiquid, false);
                        if (l == null || l.amount < bucketLiquid.amount) {
                            filledBucket = null;
                        }
                    } else {
                        filledBucket = null;
                    }
                }
                if (filledBucket == null || !ItemHelper.disposePlayerItem(ci, filledBucket, player, true)) continue;
                if (!player.field_70170_p.field_72995_K) {
                    player.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                }
                itcb.drain(ForgeDirection.UNKNOWN, bucketLiquid, true);
                return true;
            }
        }
        return false;
    }

    public static void pumpLiquid(IFluidTank iFluidTank, TileEntity from) {
        if (iFluidTank != null && iFluidTank.getFluidAmount() > 0) {
            int amount;
            FluidStack l = iFluidTank.getFluid().copy();
            l.amount = amount = Math.min(l.amount, 1000);
            for (BlockPosition adj : new BlockPosition(from).getAdjacent(true)) {
                IFluidHandler tile = adj.getTileEntity(from.func_145831_w(), IFluidHandler.class);
                if (tile == null || !tile.canFill(adj.orientation.getOpposite(), l.getFluid())) continue;
                int filled = tile.fill(adj.orientation.getOpposite(), l, true);
                iFluidTank.drain(filled, true);
                if ((amount -= filled) > 0) continue;
                break;
            }
        }
    }
}

