/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mariculture.handlers;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mariculture.api.fishery.Loot;
import mariculture.api.fishery.RodType;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mariculture.MaricultureHelper;
import modtweaker2.utils.BaseDescriptionAddition;
import modtweaker2.utils.BaseDescriptionRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mariculture.Fishing")
public class Fishing {
    public static HashMap<String, RodType> rodTypes = new HashMap();

    @ZenMethod
    public static void addJunk(IItemStack loot, double chance, @Optional String type, @Optional boolean exact, @Optional int[] dimension) {
        Fishing.addLoot(InputHelper.toStack(loot), chance, type, exact, dimension, Loot.Rarity.JUNK);
    }

    @ZenMethod
    public static void addGood(IItemStack loot, double chance, @Optional String type, @Optional boolean exact, @Optional int[] dimension) {
        Fishing.addLoot(InputHelper.toStack(loot), chance, type, exact, dimension, Loot.Rarity.GOOD);
    }

    @ZenMethod
    public static void addRare(IItemStack loot, double chance, @Optional String type, @Optional boolean exact, @Optional int[] dimension) {
        Fishing.addLoot(InputHelper.toStack(loot), chance, type, exact, dimension, Loot.Rarity.RARE);
    }

    private static void addLoot(ItemStack stack, double chance, String type, boolean exact, int[] dimension, Loot.Rarity rarity) {
        if (dimension == null || dimension.length == 0) {
            dimension = new int[]{Short.MAX_VALUE};
        }
        if (type == null) {
            type = "dire";
        }
        for (int dim : dimension) {
            MineTweakerAPI.apply((IUndoableAction)new AddLoot(new Loot(stack, chance, rarity, dim, rodTypes.get(type), exact), rarity.name()));
        }
    }

    @ZenMethod
    public static void removeLoot(IItemStack loot) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveLoot(InputHelper.toStack(loot)));
    }

    static {
        rodTypes.put("net", RodType.NET);
        rodTypes.put("old", RodType.OLD);
        rodTypes.put("good", RodType.GOOD);
        rodTypes.put("dire", RodType.DIRE);
        rodTypes.put("super", RodType.SUPER);
        rodTypes.put("flux", RodType.FLUX);
        if (Loader.isModLoaded((String)"AWWayofTime")) {
            try {
                rodTypes.put("blood", (RodType)ReflectionHelper.getStaticObject(Class.forName("mariculture.plugins.PluginBloodMagic"), "BLOOD"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static class RemoveLoot
    extends BaseDescriptionRemoval {
        private HashMap<Loot.Rarity, Loot> loot = new HashMap();
        private final ItemStack stack;

        public RemoveLoot(ItemStack stack) {
            super("Fishing Loot");
            this.stack = stack;
        }

        public void apply() {
            this.loot.clear();
            this.apply(Loot.Rarity.JUNK);
            this.apply(Loot.Rarity.GOOD);
            this.apply(Loot.Rarity.RARE);
        }

        public void apply(Loot.Rarity rarity) {
            ArrayList<Loot> list = MaricultureHelper.loot.get(rarity);
            int preSize = list.size();
            for (Loot l : list) {
                if (!StackHelper.areEqual(l.loot, this.stack)) continue;
                this.loot.put(rarity, l);
                break;
            }
            list.remove(this.loot);
            if (list.size() != preSize) {
                MaricultureHelper.loot.put(rarity, list);
            }
        }

        public void undo() {
            for (Map.Entry<Loot.Rarity, Loot> entry : this.loot.entrySet()) {
                this.undo(entry.getKey(), entry.getValue());
            }
        }

        public void undo(Loot.Rarity rarity, Loot l) {
            ArrayList<Loot> list = MaricultureHelper.loot.get(rarity);
            list.add(l);
            MaricultureHelper.loot.put(rarity, list);
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class AddLoot
    extends BaseDescriptionAddition {
        private final Loot loot;

        public AddLoot(Loot loot, String description) {
            super("Fishing Loot - " + description);
            this.loot = loot;
        }

        public void apply() {
            ArrayList<Loot> list = MaricultureHelper.loot.get(this.loot.rarity);
            list.add(this.loot);
            MaricultureHelper.loot.put(this.loot.rarity, list);
        }

        public void undo() {
            ArrayList<Loot> list = MaricultureHelper.loot.get(this.loot.rarity);
            list.remove(this.loot);
            MaricultureHelper.loot.put(this.loot.rarity, list);
        }

        @Override
        public String getRecipeInfo() {
            return this.loot.loot.func_82833_r();
        }
    }
}

