/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.chisel;

import com.cricketcraft.chisel.api.carving.CarvingUtils;
import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class ChiselHelper {
    public static ICarvingGroup getGroup(String name) {
        return CarvingUtils.getChiselRegistry().getGroup(name);
    }

    public static ICarvingGroup getGroup(IItemStack stack) {
        return CarvingUtils.getChiselRegistry().getGroup(Block.func_149634_a((Item)InputHelper.toStack(stack).func_77973_b()), stack.getDamage());
    }

    public static ICarvingVariation getVariation(IItemStack stack) {
        ICarvingGroup g = ChiselHelper.getGroup(stack);
        if (g != null) {
            for (ICarvingVariation v : g.getVariations()) {
                if (v.getBlock() != Block.func_149634_a((Item)InputHelper.toStack(stack).func_77973_b()) || v.getBlockMeta() != stack.getDamage()) continue;
                return v;
            }
        }
        return null;
    }

    public static ICarvingVariation makeVariation(IItemStack stack) {
        return new CarvingVariation(Block.func_149634_a((Item)InputHelper.toStack(stack).func_77973_b()), stack.getDamage());
    }

    public static ICarvingGroup makeGroup(String name) {
        return new CarvingGroup(name);
    }

    public static boolean groupContainsVariation(ICarvingGroup group, ICarvingVariation variation) {
        for (ICarvingVariation otherVariation : group.getVariations()) {
            if (otherVariation.getBlock() != variation.getBlock() || otherVariation.getBlockMeta() != variation.getBlockMeta()) continue;
            return true;
        }
        return false;
    }

    static class CarvingGroup
    implements ICarvingGroup {
        private String name;
        private String sound;
        private String oreName;
        private List<ICarvingVariation> variations = Lists.newArrayList();

        public CarvingGroup(String name) {
            this.name = name;
        }

        public List<ICarvingVariation> getVariations() {
            return Lists.newArrayList(this.variations);
        }

        public void addVariation(ICarvingVariation variation) {
            this.variations.add(variation);
            Collections.sort(this.variations, new Comparator<ICarvingVariation>(){

                @Override
                public int compare(ICarvingVariation o1, ICarvingVariation o2) {
                    return CarvingUtils.compare((ICarvingVariation)o1, (ICarvingVariation)o2);
                }
            });
        }

        public boolean removeVariation(ICarvingVariation variation) {
            ICarvingVariation toRemove = null;
            for (ICarvingVariation v : this.variations) {
                if (v.getBlock() != variation.getBlock() || v.getBlockMeta() != variation.getBlockMeta()) continue;
                toRemove = v;
            }
            return toRemove == null ? false : this.variations.remove(toRemove);
        }

        public String getName() {
            return this.name;
        }

        public String getSound() {
            return this.sound;
        }

        public void setSound(String sound) {
            this.sound = sound;
        }

        public String getOreName() {
            return this.oreName;
        }

        public void setOreName(String oreName) {
            this.oreName = oreName;
        }
    }

    static class CarvingVariation
    implements ICarvingVariation {
        Block block;
        int meta;

        public CarvingVariation(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getBlockMeta() {
            return this.meta;
        }

        public int getItemMeta() {
            return this.meta;
        }

        public int getOrder() {
            return 99;
        }
    }
}

